﻿{
	var mainUI = createUI(this);
    
    if ( mainUI != null && mainUI instanceof Window) {
	mainUI.show();
    }
	
	function createUI(thisObj) {
		
		var pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", "Widget Launcher", undefined, {resizeable:true}); //replace undefined with [300,300,570,550]??
			
		if (pal != null) {
				
			var res =
				"group { \
					orientation:'column', alignment:['left','top'], \
						launch1: Button { text:'Grid 3D', preferredSize:[160,20], alignment:['left','center'] }, \
						launch2: Button { text:'Horizon 3D', preferredSize:[160,20], alignment:['right','center'] }, \
						launch3: Button { text:'Widget 3D', preferredSize:[160,20], alignment:['right','center'] }, \
					}, \
				}";
				
		}
	
		pal.grp = pal.add(res);
		
				
		pal.grp.launch1.onClick = do3DGrid;
		pal.grp.launch2.onClick = doHorizon3D;
		pal.grp.launch3.onClick = doWidget3D;
        
         pal.layout.layout(true);
		pal.layout.resize();
		pal.onResizing = pal.onResize = function () {this.layout.resize();}
	
		return(pal);
		
	}

	// 3D Grid V1.04 (build 1) © Ben Rollason. May 2010	
	
	function do3DGrid() {
		
	
		var proj = app.project;
		var undoStr = "Grid 3D";
		var activeItem = proj.activeItem;
		
		var G3D = null;
		var G3D = new Object();
		
		//basics
		G3D.scriptName = "Grid 3D";
		G3D.version = "1.0";
		G3D.scriptTitle = G3D.scriptName + G3D.version;
		
		//UI data
		G3D.scrollSize = "[130,20]";
		(parseFloat(app.version) >= 9.0) ? G3D.eTextSize = "[30,-1]" : G3D.eTextSize = "[30,15]";
		(parseFloat(app.version) >= 9.0) ? G3D.eTextSize2 = "[40,-1]" : G3D.eTextSize2 = "[40,15]";
		G3D.panelSize = "[210,-1]";
		
		//key data
		G3D.sizeX = 500;
		G3D.sizeZ = 500;
		G3D.divisionsX = 20;
		G3D.divisionsZ = 20;
		G3D.placement = [0,0,0];
		G3D.posIndex = 0; //can be 0,1 or 2.... corresponding to bottom of comp, compheight.2 below cam, origin
		
		//buttons
		G3D.strHelp = "?";
		G3D.strButton = "Create";
		G3D.undrCamButton = "XYZ";
		
		//help and alerts
		G3D.help = "";
		G3D.help += "© Ben Rollason 2010.\nvfx.benrollason.com\n\nRun the script to create a floor grid to help you navigate the AE 3D environment - like in a 3D program.\n\n";
		G3D.help += "Choose grid unit size, number of units and placement and click Create.\n\n";
		G3D.help += "Note, that owing to the After Effects coordinate system, placing a floor grid at [0,0,0] will place it above you with its anchor point in the top left corner of the screen.";
		G3D.help += "Therefore, placement defaults to placing the grid's anchor point at the middle bottom of the active camera's view.";
		G3D.help += "By clicking the XYZ button, you can toggle the setting between this, comp.height/2 below the camera and the origin.";
				
		G3D.notEnglish = "As for most scripts, After Effects needs to be running in English for " + G3D.scriptName + " to work.";
		G3D.versionTooOld = "You need to be using After Effects CS3 or above for " + G3D.scriptName + " to work.";
		G3D.noActiveItem = "You must have a composition selected to run " + G3D.scriptName + ".";
		
		if(G3Dpreflight()) {	
				
				if((activeItem) && (activeItem != null) && (activeItem instanceof CompItem)) {
					G3D.placement = G3Dplacement(G3D.posIndex);
				}
				
				G3D.toolsPanel = G3DcreateUI(this);
				G3D.toolsPanel.show();
				
		}
	
		function G3DdegsToRads(degs) {
			return(Math.PI*2*degs/360);
		}
	
		function G3Dplacement(aIndex) {
			
			var tRet;
			activeItem = proj.activeItem;
			
			if(activeItem && activeItem != null) {
				switch (aIndex) 
			
				{
			
					case 0:
						
						// original at middle bottom of default camera's view
						tRet = [activeItem.width/2, activeItem.height, 0];
						break;
						
					case 1:
					
						//origin compheight/2 below the current camera
						
						if(activeItem.activeCamera) {
							G3D.camPos = activeItem.activeCamera.transform.position.value;
							G3D.camPos = [Math.round(G3D.camPos[0]), Math.round(G3D.camPos[1]), Math.round(G3D.camPos[2])];
						} else {
							G3D.camPos = [ activeItem.width/2,  activeItem.height/2, Math.round((- activeItem.width/2) / Math.tan(G3DdegsToRads(39.6/2)))];
						}
						
						tRet = G3D.camPos + [0, activeItem.height/2, 0]; 
						break;
						
					case 2:
					
						//origin at world origin
						tRet = [0,0,0];
						break;
						
					case 3:
					
						//origin at middle bottom of current camera's view
						//this is work in progress and requires a math version of expression language's toWorld function.
						
						if(activeItem.activeCamera) {
							G3D.camPos = activeItem.activeCamera.transform.position.value;
						} else {
							G3D.camPos = [ activeItem.width/2,  activeItem.height/2, Math.round((- activeItem.width/2) / Math.tan(degsToRads(39.6/2)))];
						}
						
						tRet = [0,0,0];//tRet = ??
						break;
						
					default:
					
						tRet = [activeItem.width/2, activeItem.height, 0];
						break;
						
					
				}//switch
		
			} else {
				
				tRet = [0,0,0];
				
			} //if(activeItem && activeItem != null) 
		
			return(tRet);
			
			
		}
	
		function G3Dpreflight() {
				
			var isEnglish = ((app.isoLanguage == "en_US") || (app.language == Language.ENGLISH));
			var appVersionTooOld = (parseFloat(app.version) < 8.0)
	
			if(appVersionTooOld) {
				alert(G3D.versionTooOld);
				return(false);
			} else if (!isEnglish) {
				alert(G3D.notEnglish);
				return(false);
			} else {
				return(true);
			}
		
		}
		
	
		function G3DcreateUI(thisObj) {
			
			var pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", G3D.scriptName, undefined, {resizeable:true}); //replace undefined with [300,300,570,550]??
				
			if (pal != null) {
					
				var res =
					"group { \
						orientation:'column', alignment:['left','top'], \
						Panel1: Panel { text: 'Division Size', orientation: 'column', minimumSize:" + G3D.panelSize + ",\
							Gr1: Group {\
								alignment:['right','top'], spacing:5,\
								sizeXText: StaticText { text:'X ', preferredSize:[-1,20], alignment:['right','center'] }, \
								sizeXScroll:Scrollbar { minvalue:100, maxvalue:1000, preferredSize:"+ G3D.scrollSize +", value: " + G3D.sizeX + ", stepdelta:1, jumpdelta:50, alignment:['fill','center'] }, \
								sizeXEditText: EditText { text:'" + G3D.sizeX + "', characters:5, preferredSize:" + G3D.eTextSize + ", alignment:['right','center'], } \
							}\
							Gr2: Group {\
								alignment:['right','top'], spacing:5,\
								sizeZText: StaticText { text:'Z ', preferredSize:[-1,20], alignment:['right','center'] }, \
								sizeZScroll:Scrollbar { minvalue:100, maxvalue:1000, preferredSize:"+ G3D.scrollSize +", value: " + G3D.sizeZ + ", stepdelta:1, jumpdelta:50, alignment:['fill','center'] }, \
								sizeZEditText: EditText { text:'" + G3D.sizeZ + "', characters:5, preferredSize:" + G3D.eTextSize + ", alignment:['right','center'], } \
							}\
						}\
						Panel2: Panel { text: 'No. Divisions', orientation: 'column', minimumSize:" + G3D.panelSize + ",\
							Gr1: Group {\
								alignment:['right','top'], spacing:5,\
								divisionsXText: StaticText { text:'X ', preferredSize:[-1,20], alignment:['right','center'] }, \
								divisionsXScroll:Scrollbar { minvalue:2, maxvalue:50, preferredSize:"+ G3D.scrollSize +", value: " + G3D.divisionsX + ", stepdelta:1, jumpdelta:5, alignment:['fill','center'] }, \
								divisionsXEditText: EditText { text:'" + G3D.divisionsX + "', characters:5, preferredSize:" + G3D.eTextSize + ", alignment:['right','center'], } \
							}\
							Gr2: Group {\
								alignment:['right','top'], spacing:5,\
								divisionsZText: StaticText { text:'Z ', preferredSize:[-1,20], alignment:['right','center'] }, \
								divisionsZScroll:Scrollbar { minvalue:2, maxvalue:50, preferredSize:"+ G3D.scrollSize +", value: " + G3D.divisionsZ + ", stepdelta:1, jumpdelta:5, alignment:['fill','center'] }, \
								divisionsZEditText: EditText { text:'" + G3D.divisionsZ + "', characters:5, preferredSize: " + G3D.eTextSize + ", alignment:['right','center'], } \
							}\
						}\
						Panel3: Panel { text: 'Placement', orientation: 'row', minimumSize:" + G3D.panelSize + ",\
							Gr1: Group {\
								alignment:['right','top'], spacing:5,\
								placementXText: StaticText { text:'X ', preferredSize:[-1,20], alignment:['right','center'] }, \
								placementXEditText: EditText { text:'" + G3D.placement[0] + "', characters:5, preferredSize:" + G3D.eTextSize2 + ", alignment:['right','center'], } \
							}\
							Gr2: Group {\
								alignment:['right','top'], spacing:5,\
								placementYText: StaticText { text:'Y ', preferredSize:[-1,20], alignment:['right','center'] }, \
								placementYEditText: EditText { text:'" + G3D.placement[1] + "', characters:5, preferredSize:" + G3D.eTextSize2 + ", alignment:['right','center'], } \
							}\
							Gr3: Group {\
								alignment:['right','top'], spacing:5,\
								placementZText: StaticText { text:'Z ', preferredSize:[-1,20], alignment:['right','center'] }, \
								placementZEditText: EditText { text:'" + G3D.placement[2] + "', characters:5, preferredSize:" + G3D.eTextSize2 + ", alignment:['right','center'], } \
							}\
						}\
						" + ((parseFloat(app.version) >= 9.0) ? "Panel4: Panel { text: 'Progress', orientation: 'row', minimumSize:" + G3D.panelSize + ",progress: Progressbar { alignment:['center','top'], preferredSize:[180,15] }}" : "")
						+ "footer: Group { \
								alignment:['right','top'], \
								help: Button { text:'" + G3D.strHelp + "', preferredSize:[30,20], alignment:['left','center'] }, \
								underCamButton: Button { text:'" + G3D.undrCamButton +"', preferredSize:[60,20], alignment:['right','center'] }, \
								mainButton: Button { text:'" + G3D.strButton +"', preferredSize:[60,20], alignment:['right','center'] }, \
						}, \
					}";
					
				pal.grp = pal.add(res);
				
				var darkBrush = pal.graphics.newPen(pal.graphics.BrushType.SOLID_COLOR, [0,0,0], 1);
				pal.grp.Panel1.Gr1.sizeXEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel1.Gr2.sizeZEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel2.Gr1.divisionsXEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel2.Gr2.divisionsZEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel3.Gr1.placementXEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel3.Gr2.placementYEditText.graphics.foregroundColor  = darkBrush;
				pal.grp.Panel3.Gr3.placementZEditText.graphics.foregroundColor  = darkBrush;
				
				pal.layout.layout(true);
				pal.grp.minimumSize = pal.grp.size;
				pal.layout.resize();
				pal.onResizing = pal.onResize = function () {this.layout.resize();}
				//pal.onFocus = alert("focus");
				
				pal.grp.footer.help.onClick = function () {alert(G3D.scriptTitle + "\n" + G3D.help, G3D.scriptName);}
				pal.grp.footer.underCamButton.onClick = function ()
				{
					G3D.posIndex = (G3D.posIndex + 1)%3; //change this to 4 if and when I add the fourth option
					G3D.placement = G3Dplacement(G3D.posIndex);
					pal.grp.Panel3.Gr1.placementXEditText.text = G3D.placement[0];
					pal.grp.Panel3.Gr2.placementYEditText.text = G3D.placement[1];
					pal.grp.Panel3.Gr3.placementZEditText.text = G3D.placement[2];
				}
				pal.grp.footer.mainButton.onClick = G3DmainFunction;
				
				//link scrollbar and text
				//SIZE X
				pal.grp.Panel1.Gr1.sizeXScroll.onChange = pal.grp.Panel1.Gr1.sizeXScroll.onChanging = function () 
				{
					this.value = Math.round(this.value);    
					G3D.sizeX = this.value;
					this.parent.sizeXEditText.text = G3D.sizeX;
				}
				pal.grp.Panel1.Gr1.sizeXEditText.onChange = function ()
				{
					if (isNaN(this.text)) this.text = G3D.sizeX;
					this.parent.sizeXScroll.value = parseInt(this.text);
					G3D.sizeX = parseInt(this.text);
				}
		
				//SIZE Z
				pal.grp.Panel1.Gr2.sizeZScroll.onChange = pal.grp.Panel1.Gr2.sizeZScroll.onChanging = function () 
				{
					this.value = Math.round(this.value);    
					G3D.sizeZ = this.value;
					this.parent.sizeZEditText.text = G3D.sizeZ;
				}
				pal.grp.Panel1.Gr2.sizeZEditText.onChange = function ()
				{
					if (isNaN(this.text)) this.text = G3D.sizeZ;
					this.parent.sizeZScroll.value = parseInt(this.text);
					G3D.sizeZ = parseInt(this.text);
				}
			
				//DIVISIONS X
				pal.grp.Panel2.Gr1.divisionsXScroll.onChange = pal.grp.Panel2.Gr1.divisionsXScroll.onChanging = function () 
				{
					this.value = Math.round(this.value);    
					G3D.divisionsX = this.value;
					this.parent.divisionsXEditText.text = G3D.divisionsX;
				}
				pal.grp.Panel2.Gr1.divisionsXEditText.onChange = function ()
				{
					if (isNaN(this.text)) this.text = G3D.divisionsX;
					this.parent.divisionsXScroll.value = parseInt(this.text);
					G3D.divisionsX = parseInt(this.text);
				}
			
				//DIVISIONS Z
				pal.grp.Panel2.Gr2.divisionsZScroll.onChange = pal.grp.Panel2.Gr2.divisionsZScroll.onChanging = function () 
				{
					this.value = Math.round(this.value);    
					G3D.divisionsZ = this.value;
					this.parent.divisionsZEditText.text = G3D.divisionsZ;
				}
				pal.grp.Panel2.Gr2.divisionsZEditText.onChange = function ()
				{
					if (isNaN(this.text)) this.text = G3D.divisionsZ;
					this.parent.divisionsZScroll.value = parseInt(this.text);
					G3D.divisionsZ = parseInt(this.text);
				}
			
				//progress bar
				if(parseFloat(app.version) >= 9.0) pal.grp.Panel4.progress.value = 0;
			
				
			} //if (pal != null)
		
			return(pal);
			
		} // function createUI
		

		function G3Dtrace(s) {
			$.writeln(s); // writes to the ExtendScript interface
			//writeLn("3DR: " + s); // writes in the AE info window
		}
	
		function G3DmainFunction() {
			//MAIN FUNCTION
			
			proj = app.project;
			activeItem = proj.activeItem;
			
			if (!activeItem || ! activeItem instanceof CompItem){
				alert(G3D.noActiveItem);
			} else {
					
				app.beginUndoGroup(undoStr);
				
				G3D.placement = [parseFloat(G3D.toolsPanel.grp.Panel3.Gr1.placementXEditText.text), parseFloat(G3D.toolsPanel.grp.Panel3.Gr2.placementYEditText.text), parseFloat(G3D.toolsPanel.grp.Panel3.Gr3.placementZEditText.text)];
				
				var compDims = [Math.floor(G3D.sizeX * G3D.divisionsX), Math.floor(G3D.sizeZ * G3D.divisionsZ)];
				
				//create a new composition in a folder in the same location as the activeComp
				G3D.folder = proj.items.addFolder(G3D.scriptName);
				G3D.comp = proj.items.addComp(G3D.scriptName + " - " + activeItem.name, compDims[0], compDims[1], 1, activeItem.duration, activeItem.frameRate);
				G3D.comp.parentFolder = G3D.folder;
				G3D.folder.parentFolder = activeItem.parentFolder;
				
				//create a null in the middle
				G3D.cNull = G3D.comp.layers.addNull(G3D.comp.duration);
				G3D.cNull.threeDLayer = true;
				G3D.cNull.transform.position.setValue([G3D.comp.width/2, G3D.comp.height/2, 0]);
				
				//create solid and set to wireframe
				G3D.indexLayer = G3D.comp.layers.addSolid([0,0,0], G3D.scriptName + " element", G3D.sizeX, G3D.sizeZ, 1, G3D.comp.duration);
				G3D.indexLayer.threeDLayer = true;
				G3D.indexLayer.quality = LayerQuality.WIREFRAME;
				G3D.indexLayer.transform.anchorPoint.setValue([0,0,0]);
				G3D.indexLayer.transform.position.setValue([0,0,0]);
				
				//loop - duplicate and place solid
				
				var tProgress = 0;
				var tProgressUnit = 1/(G3D.divisionsZ*G3D.divisionsX);
				
				for(var i = 0; i < G3D.divisionsZ; i++) 
				{
					for(var j = 0; j < G3D.divisionsX; j++)
					{
						if(parseFloat(app.version) >= 9.0) {
							tProgress++;
							G3D.toolsPanel.grp.Panel4.progress.value = tProgress*100*tProgressUnit;
							G3D.toolsPanel.update();
						}
						var tLayer = G3D.indexLayer.duplicate();
						tLayer.transform.position.setValue([G3D.sizeX*j, G3D.sizeZ*i, 0]);
						//tLayer.name = tLayer.name + " " + i + "/" + j;
						//trace("solid " + i + "/" + j);
						tLayer.parent = G3D.cNull;
					}
				}
				
				//delete the original
				G3D.indexLayer.remove();
				
				G3D.cNull.transform.orientation.setValue([90,0,0]);
				
				//put the comp as the top layer of activeItem
				G3D.gridLayer = activeItem.layers.add(G3D.comp,activeItem.duration);
				
				//name the layer
				G3D.gridLayer.name = G3D.scriptName;
				
				//set it to collapsed / 3D
				G3D.gridLayer.threeDLayer = true;
				G3D.gridLayer.collapseTransformation = true;
				
				//position it
				G3D.gridLayer.transform.position.setValue(G3D.placement);
				
				//place it behind bottommost 3D layer
				for(var i = activeItem.numLayers; i >= 1; i--) {
					if(activeItem.layer(i).threeDLayer && activeItem.layer(i) != G3D.gridLayer) {
						G3D.gridLayer.moveAfter(activeItem.layer(i));
						break;
					}
				}
			
				//move it to time 0
				G3D.gridLayer.startTime = activeItem.displayStartTime;
				
				//lock it
				G3D.gridLayer.guideLayer = true;
				G3D.gridLayer.locked = true;
				
				//set progress bar back to 0
				
				if(parseFloat(app.version) >= 9.0) G3D.toolsPanel.grp.Panel4.progress.value = 0;
				
				
				app.endUndoGroup();
				
			}
			
		} //function mainFunction()
	
	}//function do3DGrid


		
	
	//Horizon 3D V1.05 (build 1) © Ben Rollason. May 2010
		
	function doHorizon3D() {
	
		var proj = app.project;
		var undoStr = "Horizon 3D";
		var activeItem = proj.activeItem;
		
		var H3D = null;
		var H3D = new Object();
		
		//basics
		H3D.scriptName = "Horizon 3D";
		H3D.version = "1.0";
		H3D.scriptTitle = H3D.scriptName + " V" + H3D.version;
		
		//UI data
		H3D.scrollSize = "[130,20]";
		H3D.eTextSize = "[30,-1]";
		H3D.eTextSize2 = "[60,-1]";
		if(parseFloat(app.version) < 9.0) H3D.eTextSize2 = "[60,16]";
		H3D.panelSize = "[190,-1]";
		
		//key data
		H3D.placement = 0;
		H3D.posIndex = 0; //can be 0,1 or 2.... corresponding to bottom of comp, compheight.2 below cam, origin
		H3D.useTriangle = 1;
		H3D.useBaseline = 0;
		H3D.useGroundfill = 0;
		
		//buttons
		H3D.strHelp = "?";
		H3D.strButton = "Create";
		H3D.strPlacementButton = "XYZ";
		
		//help and alerts
		H3D.help = "";
		H3D.help += "© Ben Rollason 2010.\nvfx.benrollason.com\n\nRun the script to create a layer that shows you the horizon line.\n\n";
		H3D.help += "Use display options to decide the placement of the ground plane and how the orientation of the horizon (i.e. which way up it is) is displayed.";
		
		H3D.tip0 = "The position of the ground plane on the Y-axis. Since the ground plane extends along the X and Z axes to an infinite distance, only the Y-axis is important to define the plane.";
		H3D.tip0 += " The default value is a Y value of the composition height, since unlike 3D programs, a floor at Y: 0 would put it above After Effects default camera position!";
		H3D.tip0 += " Change it as you see fit. It can also be altered once the horizon has been created.";
		
		H3D.tip1 = "Check this to show a small triangle on the horizon, to indicate which way is up.";
		H3D.tip2 = "Check this to show a line underneath the horizon to indicate which way is down.";
		H3D.tip3 = "Check this to fill the area that is the ground with a translucent color. This works slightly differently to the other two methods in that it can show you whether you are above or below the ground level.";
		H3D.tip3 += "If you pass through the ground level, the horizon doesn't move, but the ground fill will now appear above you. However, there is some processing overhead. The other two orientation displays are ";
		H3D.tip3 += "really fast, but this one can slow things down a little.";
				
		H3D.notEnglish = "As for most scripts, After Effects needs to be running in English for " + H3D.scriptName + " to work.";
		H3D.versionTooOld = "You need to be using After Effects CS3 or above for " + H3D.scriptName + " to work.";
		H3D.noActiveItem = "You must have a composition selected to run " + H3D.scriptName + ".";
		
		if(H3Dpreflight()) {	
				
			H3D.toolsPanel = H3DcreateUI(this);
			H3D.toolsPanel.show();
				
		}
	
		function H3Dplacement(aIndex) {
			
			//redundant method - maybe useful for future though, so I'll leave it in!
			
			var tRet;
			
			switch (aIndex) 
			
			{
			
				case 0:
					
					// original at middle bottom of default camera's view
					tRet = [activeItem.width/2, activeItem.height, 0];
					break;
					
				case 1:
				
					//origin compheight/2 below the current camera
					
					if(activeItem.activeCamera) {
						H3D.camPos = activeItem.activeCamera.transform.position.value;
						H3D.camPos = [Math.round(H3D.camPos[0]), Math.round(H3D.camPos[1]), Math.round(H3D.camPos[2])];
					} else {
						H3D.camPos = [ activeItem.width/2,  activeItem.height/2, Math.round((- activeItem.width/2) / Math.tan(degsToRads(39.6/2)))];
					}
					
					tRet = H3D.camPos + [0, activeItem.height/2, 0]; 
					break;
					
				case 2:
				
					//origin at world origin
					tRet = [0,0,0];
					break;
					
				case 3:
				
					//origin at middle bottom of current camera's view
					//this is work in progress and requires a math version of expression language's toWorld function.
					
					if(activeItem.activeCamera) {
						H3D.camPos = activeItem.activeCamera.transform.position.value;
					} else {
						H3D.camPos = [ activeItem.width/2,  activeItem.height/2, Math.round((- activeItem.width/2) / Math.tan(degsToRads(39.6/2)))];
					}
					
					tRet = [0,0,0];//tRet = ??
					break;
					
				default:
				
					tRet = [activeItem.width/2, activeItem.height, 0];
					break;
					
				
			}
		
			return(tRet);
			
			
		}
	
		function H3DdegsToRads(degs) {
			return(Math.PI*2*degs/360);
		}
	
	
		function H3Dpreflight() {
				
			var isEnglish = ((app.isoLanguage == "en_US") || (app.language == Language.ENGLISH));
			var appVersionTooOld = (parseFloat(app.version) < 8.0)
	
			if(appVersionTooOld) {
				alert(H3D.versionTooOld);
				return(false);
			} else if (!isEnglish) {
				alert(H3D.notEnglish);
				//alert("Current language code: "+ app.language);
				return(false);
			} else {
				return(true);
			}
		
		}
		
	
		function H3DcreateUI(thisObj) {
			
			var pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", H3D.scriptName, undefined, {resizeable:true}); //replace undefined with [300,300,570,550]??
				
			if (pal != null) {
				
				if(activeItem && (activeItem != null) && (activeItem instanceof CompItem)) {
					H3D.placement = activeItem.height;
				} else {
					H3D.placement = 0;
				}
					
				var res =
					"group { \
						orientation:'column', alignment:['left','top'], \
						Panel1: Panel { text: 'Ground Placement', orientation: 'row', minimumSize:" + H3D.panelSize + ", margins: 15, spacing: 5, \
							Gr1: Group {\
								alignment:['left','center'], minimumSize: [120,-1],  spacing:15,\
								placementYText: StaticText { text:'Y-axis', preferredSize:[-1,-1], alignment:['left','center'] }, \
								placementYEditText: EditText { text:'" + H3D.placement + "', characters:6, preferredSize:" + H3D.eTextSize2 + ", alignment:['left','center'], } \
							}\
							Gr2: Group {\
								alignment:['right','center'], spacing:15,\
								tip0: Button { text:'" + H3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
							}\
						}\
						Panel2: Panel { text: 'Display Options', orientation: 'column', minimumSize:" + H3D.panelSize + ", margins:15, spacing: 5, \
							Gr1: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr1a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									triangleText: StaticText { text:'Triangle:', minimumSize:[60,-1], alignment:['left','center'] }, \
									triangleCheckbox:Checkbox {text:'',alignment:['left','center'],value:" + H3D.useTriangle + ", preferredSize: [25,25],},\
								}\
								Gr1b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip1: Button { text:'" + H3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
							Gr2: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr2a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									baselineText: StaticText { text:'Base line:', minimumSize:[60,-1], alignment:['left','center'] }, \
									baselineCheckbox:Checkbox {text:'',alignment:['left','center'],value: " + H3D.useBaseline + ", preferredSize: [25,25],},\
								}\
								Gr2b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip2: Button { text:'" + H3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
							Gr3: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr3a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									groundfillText: StaticText { text:'Ground fill:', minimumSize:[60,-1], alignment:['left','center'] }, \
									groundfillCheckbox:Checkbox {text:'',alignment:['left','center'],value:" + H3D.useGroundfill + ", preferredSize: [25,25],},\
								}\
								Gr3b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip3: Button { text:'" + H3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
						}\
						footer: Group { \
							alignment:['right','top'], \
							help: Button { text:'" + H3D.strHelp + "', preferredSize:[30,20], alignment:['left','center'] }, \
							mainButton: Button { text:'" + H3D.strButton +"', preferredSize:[60,20], alignment:['right','center'] }, \
						}, \
					}";
					
					
				pal.grp = pal.add(res);
				
				var darkBrush = pal.graphics.newPen(pal.graphics.BrushType.SOLID_COLOR, [0,0,0], 1);
				pal.grp.Panel1.Gr1.placementYEditText.graphics.foregroundColor  = darkBrush;
				
				pal.layout.layout(true);
				pal.grp.minimumSize = pal.grp.size;
				pal.layout.resize();
				pal.onResizing = pal.onResize = function () {this.layout.resize();}
				//pal.onFocus = alert("focus");
				
				pal.grp.Panel1.Gr1.placementYEditText.onChange = function() 
				{
					if (isNaN(this.text)) this.text = H3D.placement;
					H3D.placement = parseFloat(this.text);
				}
				pal.grp.Panel1.Gr2.tip0.onClick = function () {alert(H3D.scriptTitle + "\n" + H3D.tip0, H3D.scriptName);}
				pal.grp.Panel2.Gr1.Gr1b.tip1.onClick = function () {alert(H3D.scriptTitle + "\n" + H3D.tip1, H3D.scriptName);}
				pal.grp.Panel2.Gr2.Gr2b.tip2.onClick = function () {alert(H3D.scriptTitle + "\n" + H3D.tip2, H3D.scriptName);}
				pal.grp.Panel2.Gr3.Gr3b.tip3.onClick = function () {alert(H3D.scriptTitle + "\n" + H3D.tip3, H3D.scriptName);}
				
				pal.grp.Panel2.Gr1.Gr1a.triangleCheckbox.onClick = function () {H3D.useTriangle = pal.grp.Panel2.Gr1.Gr1a.triangleCheckbox.value}
				pal.grp.Panel2.Gr2.Gr2a.baselineCheckbox.onClick = function () {H3D.useBaseline = pal.grp.Panel2.Gr2.Gr2a.baselineCheckbox.value}
				pal.grp.Panel2.Gr3.Gr3a.groundfillCheckbox.onClick = function () {H3D.useGroundfill = pal.grp.Panel2.Gr3.Gr3a.groundfillCheckbox.value}
				
				
				pal.grp.footer.help.onClick = function () {alert(H3D.scriptTitle + "\n" + H3D.help, H3D.scriptName);}
				pal.grp.footer.mainButton.onClick = H3DmainFunction;
				
				
			
				
			} //if (pal != null)
		
			return(pal);
			
		} // function createUI
		

		function H3Dtrace(s) {
			$.writeln(s); // writes to the ExtendScript interface
			//writeLn("3DR: " + s); // writes in the AE info window
		}
	
		function H3DreturnFunctionVectorIntersectPlane() {
			
			var tJS = "";
			
			tJS += "function vectorIntersectPlane(aVectorPoint, aVectorNormal, aPlanePoint, aPlaneNormal) {\n";
			tJS += "\tP0 = aVectorPoint;\n";
			tJS += "\tu = aVectorNormal;\n";
			tJS += "\tV0 = aPlanePoint;\n";
			tJS += "\tn = aPlaneNormal;\n";
			tJS += "\tw = P0 - V0;\n";
			tJS += "\tif(dot(n,u) != 0) {\n";
			tJS += "\t\ts = dot(-n,w) /  dot(n,u);\n";
			tJS += "\t\tr = P0 + s*u;\n";
			tJS += "\t\treturn(r);\n";
			tJS += "\t} else {\n";
			tJS += "\t\t//there is no solution vector is parallel to plane or lies on the plane\n";
			tJS += "\t\tif(dot(n, w) == 0) {\n";
			tJS += "\t\t\t//the point is on the plane\n";
			tJS += "\t\t\treturn(P0);\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\treturn(-1);\n";
			tJS += "\t\t}\n";
			tJS += "\t}\n";
			tJS += "}\n";			
			
			return(tJS);			
		}
	
		function H3DreturnFunctionFromWorlUniversal() {
			
			var tJS = "";
			
			tJS += "function fromWorldUniversal(aPlaneNormal, aPlanePoint, aPlaneXNormal, aPoint) {\n";
			tJS += "\taPlaneYNormal = normalize(cross(aPlaneNormal, aPlaneXNormal));\n";
			tJS += "\ttZ = dot(aPoint - aPlanePoint, aPlaneNormal);\n";
			tJS += "\ttY = dot(aPoint - aPlanePoint, aPlaneYNormal);\n";
			tJS += "\ttX = dot(aPoint - aPlanePoint, aPlaneXNormal);\n";
			tJS += "\treturn([tX,tY,tZ]);\n";
			tJS += "}\n\n";
			
			return(tJS);
			
		}
	
		function H3DreturnFunctionRoundToDecimalPlaces() {
			
			var tJS = "";
			
			tJS += "function roundToDecimalPlaces(aNumOrArray, aDP) {\n";
			tJS += "\ttIsArray = aNumOrArray instanceof Array;\n";
			tJS += "\ttIsNum = (typeof aNumOrArray == 'number') || (aNumOrArray instanceof Number);\n";
			tJS += "\tif(tIsArray) {\n";
			tJS += "\t\tfor (i in aNumOrArray) {\n";
			tJS += "\t\t\tif((typeof aNumOrArray[i] == 'number') || (aNumOrArray[i] instanceof Number)) {\n";
			tJS += "\t\t\t\taNumOrArray[i] = Math.round(aNumOrArray[i]*Math.pow(10, aDP))/Math.pow(10,aDP);\n";
			tJS += "\t\t\t\t//aNumOrArray[i] = aNumOrArray.toFixed(aDP);\n";
			tJS += "\t\t\t}\n";
			tJS += "\t\t}\n";
			tJS += "\t} else if (tIsNum) {\n";
			tJS += "\t\taNumOrArray = Math.round(aNumOrArray*Math.pow(10, aDP))/Math.pow(10,aDP);\n";
			tJS += "\t\t//aNumOrArray = aNumOrArray.toFixed(aDP);\n";
			tJS += "\t}\n";
			tJS += "\treturn(aNumOrArray);\n";
			tJS += "}\n\n";
				
			return(tJS);
		}
	
		function H3DreturnInitialTryStatement(aC, aCPos, aCPlV, aCPlX, aCPlY, aCPlP, aScrPlP) {
					
			var tJS = "";
			var tJS2 = "";
			var tJS3 = "";
			
			tJS += "try {\n";
			if(aC) tJS += "\tC = thisComp.activeCamera;\n";
			if(aCPos) tJS += "\tCPos = C.toWorld([0,0,0]);\n";
			if(aCPlV) tJS += "\tCPlV = C.toWorldVec([0,0,1]);\n";
			if(aCPlX) tJS += "\tCPlX = C.toWorldVec([1,0,0]);\n";
			if(aCPlY) tJS += "\tCPlY = C.toWorldVec([0,1,0]);\n";
			if(aCPlP) tJS += "\tCPlP = CPos + CPlV*Math.pow(10,9); //the world position of the big screen (1,000,000 from the camera)\n";
			if(aScrPlP) tJS += "\tScrPlP = CPos + CPlV*C.cameraOption.zoom; //the world position of the normal screen\n";
			tJS+= "} catch(e) {\n";
			
			tJS2 += "\ttry {\n";
			if(aC) tJS2 += "\t\tC = thisComp.layer(\"default cam pos\");\n";
			if(aCPos) tJS2 += "\t\tCPos = C.toWorld([0,0,0]);\n";
			if(aCPlV) tJS2 += "\t\tCPlV = C.toWorldVec([0,1,0]);\n";
			if(aCPlX) tJS2 += "\t\tCPlX = C.toWorldVec([1,0,0]);\n";
			if(aCPlY) tJS2 += "\t\tCPlY = C.toWorldVec([0,1,0]);\n";
			if(aCPlP) tJS2 += "\t\tCPlP = CPos + CPlV*Math.pow(10,9); //the world position of the big screen (1,000,000 from the camera)\n";
			if(aScrPlP) tJS2 += "\t\tScrPlP = CPos - CPlV*C.position[2];\n";
			tJS2 += "\t} catch(e) {\n";
			if(aCPos) tJS2 += "\t\tCPos = [thisComp.width/2, thisComp.height/2, (-thisComp.width/2) / Math.tan(degreesToRadians(39.6/2))];\n";
			if(aCPlV) tJS2 +=  "\t\tCPlV = [0,0,1];\n";
			if(aCPlX) tJS2 += "\tCPlX = [1,0,0];\n";
			if(aCPlY) tJS2 += "\t\tCPlY = [0,1,0];\n";
			if(aCPlP) tJS2 += "\t\tCPlP = CPlV*Math.pow(10,9) +CPos;\n";
			if(aScrPlP) tJS2 == "\t\tScrPlP = CPos - CPlV*CPos[2];\n";
			tJS2 += "\t}\n";
			tJS2 += "}\n\n";
			
			if(aCPos) tJS3 += "\tCPos = [thisComp.width/2, thisComp.height/2, (-thisComp.width/2) / Math.tan(degreesToRadians(39.6/2))];\n";
			if(aCPlV) tJS3 +=  "\tCPlV = [0,0,1];\n";
			if(aCPlX) tJS3 += "\tCPlX = [1,0,0];\n";
			if(aCPlY) tJS3 += "\tCPlY = [0,1,0];\n";
			if(aCPlP) tJS3 += "\tCPlP = CPlV*Math.pow(10,9) +CPos;\n";
			if(aScrPlP) tJS3 += "\tScrPlP = CPos - CPlV*CPos[2];\n";
			tJS3 += "}\n\n";
			
			//return(tJS + tJS2); //long version
			return(tJS + tJS3);
		
		}
	
		function H3DreturnFunctionVectorPointToLine() {

			var tJS = "";
			
			tJS += "function vectorPointToLine2D(linePoint, lineVector, point) {\n";
			tJS += "\tv0 = linePoint - point;\n";
			tJS += "\tlinePerp = normalize([-lineVector[1], lineVector[0]]);\n";
			tJS += "\tif(length(lineVector) > 0) {\n";
			tJS += "\t\td = dot(v0, linePerp);\n";
			tJS += "\t\treturn(d*linePerp);\n";
			tJS += "\t} else {\n";
			tJS += "\t\treturn([-1000,-1000]);\n";
			tJS += "\t}\n";
			tJS += "}\n\n";

			return(tJS);
		}
	
		function H3DreturnFunctionVectorPointToLine2D() {
			
			var tJS = "";
			
			tJS += "function vectorPointToLine2D(linePoint, lineVector, point) {\n";
			tJS += "\tv0 = linePoint - point;\n";
			tJS += "\tlinePerp = normalize([-lineVector[1], lineVector[0]]);\n";
			tJS += "\tif(length(lineVector) > 0) {\n";
			tJS += "d = dot(v0, linePerp);\n";
			tJS += "\t\treturn(d*linePerp);\n";
			tJS += "\t} else {\n";
			tJS += "\t\treturn([-1000,-1000]);\n";
			tJS += "\t}\n";
			tJS += "}\n\n";
			
			return(tJS);		
			
		}
	
	
		function H3DreturnFunctionIsFacingNormals(){
		
			var tJS = "";
			
			tJS += "function isFacingNormals(Point1, Normal1, Point2, Normal2, aLookAtEachOther) {\n";
			tJS += "\tw = Point1 - Point2;\n";
			tJS += "\tif(dot(Normal2,Normal1) != 0) {\n";
			tJS += "\t\ts1 = dot(-Normal2,w) /  dot(Normal2,Normal1);\n";
			tJS += "\t} else {\n";
			tJS += "\t\t//there is no solution vector is parallel to plane or lies on the plane\n";
			tJS += "\t\t//so it doesn't really matter what value we give s\n";
			tJS += "\t\ts1 = 0;\n";
			tJS += "\t}\n";
			tJS += "\tif(aLookAtEachOther) {\n";
			tJS += "\t\t//now switch it round\n";
			tJS += "\t\tw = Point2 - Point1;\n";
			tJS += "\t\tif(dot(Normal1,Normal2) != 0) {\n";
			tJS += "\t\t\ts2 = dot(-Normal1,w) /  dot(Normal1,Normal2);\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\t//there is no solution vector is parallel to plane or lies on the plane\n";
			tJS += "\t\t\t//so it doesn't really matter what value we give s\n";
			tJS += "\t\t\ts2 = 0;\n";
			tJS += "\t\t}\n";
			tJS += "\t\tif (s1 ==0 || s2 == 0) {\n";
			tJS += "\t\t\treturn(-1);\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\treturn(s2 < 0 && s1 <0);\n";
			tJS += "\t\t}\n";
			tJS += "\t} else {\n";
			tJS += "\t\treturn(s1 < 0);\n";
			tJS += "\t}\n";
			tJS += "}\n\n";
			
			return(tJS);
		
		}
	
		function H3DreturnFunctionPlaneIntersectPlaneUniversal() {
		
			var tJS = "";
			
			tJS +="function planeIntersectPlaneUniversal(n1, n2, P1, P2) {\n";
			tJS += "\tif ((n1 == n2) || (n1 == -n2)) {\n";
			tJS += "\t\t//planes are parallel\n";
			tJS += "\t\treturn(-1);\n";
			tJS += "\t} else {\n";
			tJS += "\t\tV = cross(n1,n2);\n";
			tJS += "\t\t//get point\n";
			tJS += "\t\t//to find any specific point on the line, take an arbitrary vector on the first plane\n";
			tJS += "\t\t//and use code from vectorIntersectPlane to find where it meets the second plane.\n";
			tJS += "\t\t//this is of course, also on the line.\n";
			tJS += "\t\tx1 = cross(n1, n1+[20,0,0]); //get x normal (arbitrary perpendicular to n1)\n";
			tJS += "\t\ty1 = cross(n1, x1);// and y normal - perpendicular to both\n";
			tJS += "\t\tP1a = P1 + 1000*normalize(x1) + 1000*normalize(y1); //an arbitrary point on Plane 1's surface\n";
			tJS += "\t\tu = P1a-P1; //an arbitrary vector on it's surface\n";
			tJS += "\t\tP = vectorIntersectPlane(P1, u, P2, n2);\n";
			tJS += "\t\tif(P == -1) {\n";
			tJS += "\t\t\t//we have been unlucky with our arbitrarily chosen vector. It is parallel to the plane.\n";
			tJS += "\t\t\t//Since we know the planes are not parallel, we try again with another slightly different vector.\n";
			tJS += "\t\t\t//It isn't possible that the second one doesn't meet it.\n";
			tJS += "\t\t\tP1a = P1 + 1000*normalize(x1) + 900*normalize(y1); //an arbitrary point on Plane 1's surface\n";
			tJS += "\t\t\tu = P1a-P1; //an arbitrary vector on it's surface\n";
			tJS += "\t\t\tP = vectorIntersectPlane(P1, u, P2, n2);\n";
			tJS += "\t\t}\n";
			tJS += "\t\treturn([P,V]); // point and vector that describe the line of intersection\n";
			tJS += "\t}\n";				   
			tJS += "}\n\n";
			
			return(tJS);			
			
		}
	
		function H3DreturnBeamTriangle1JS(argWhich, argStartOrFinish) { //arg should be 1 or 2, depending on which triangle it is //1 or 2 for start or finish
			
			var tJS = "";
			
			tJS += H3DreturnInitialTryStatement(1,0,0,0,1,0,0);
			
			tJS += "HPlV = [0,1,0]; //ground normal\n";
			tJS += "upsideDown = dot(CPlY, HPlV) < 0;\n";
			tJS += "if(effect(\"H3D: Triangle point up\")(\"Checkbox\")<0.5) upsideDown = !upsideDown;\n";
			tJS += "\ttStart = effect(\"H3D: Beam (main)\")(\"Starting Point\");\n";
			tJS += "\ttEnd = effect(\"H3D: Beam (main)\")(\"Ending Point\");\n";
			tJS += "\ttVec  = tEnd - tStart;\n";
			tJS += "\tcompMid = [thisComp.width/2, thisComp.height/2];\n";
			tJS += "\ttMid = compMid + vectorPointToLine2D(tStart, tVec, compMid);\n";
			tJS += "\tif(length(tVec) > 0) {\n";
			//tJS += "\t\tif(thisProperty.name == \"Starting Point\") {\n";
			if(argStartOrFinish == 1) {
				tJS += "\t\ttMid" + ((argWhich == 1) ? " + " : " - ") + "normalize(tVec)*effect(\"H3D: Triangle height / width\")(\"Point\")[1]/2;\n";
			} else {
				//tJS += "\t} else {\n";
				tJS += "\t\ttMid +effect(\"H3D: Triangle height / width\")(\"Point\")[0]*(upsideDown*2-1)*normalize([-tVec[1], tVec[0]]);\n";
			}
			//tJS += "\t}\n";
			tJS += "} else {\n";
			tJS += "\t[-1000,-1000];\n";
			tJS += "}\n\n";
			
			tJS += "//____________________________________FUNCTIONS____________________________________\n\n";
			
			tJS += H3DreturnFunctionVectorPointToLine2D();
			
			return(tJS);

			
			
		}
	
		function H3DreturnBeamBaseLine(argStartOrFinish) {
			
			var tJS = "";
			
			tJS += H3DreturnInitialTryStatement(1,0,0,0,1,0,0);
			
			tJS += "HPlV = [0,1,0]; //ground normal\n";
			tJS += "upsideDown = dot(CPlY, HPlV) < 0;\n";
			tJS += "if(effect(\"H3D: Triangle point up\")(\"Checkbox\")<0.5) upsideDown = !upsideDown;\n";
			tJS += "\ttStart = effect(\"H3D: Beam (main)\")(\"Starting Point\");\n";
			tJS += "\ttEnd = effect(\"H3D: Beam (main)\")(\"Ending Point\");\n";
			tJS += "\ttVec  = tEnd - tStart;\n";
			tJS += "\tcompMid = [thisComp.width/2, thisComp.height/2];\n";
			tJS += "\ttMid = compMid + vectorPointToLine2D(tStart, tVec, compMid);\n";
			//same as triangle to this point... and beyond functions line
			tJS += "tDist = effect(\"H3D: Base line distance / width\")(\"Point\")[0];\n";
			tJS += "tLength = effect(\"H3D: Base line distance / width\")(\"Point\")[1]/2;\n";
			tJS += "if(length(tVec) > 0) {\n";
			tJS += "\ttPerpUnit = (upsideDown*2-1)*normalize([-tVec[1], tVec[0]]);\n";
			tJS += "\ttParllUnit = (upsideDown*2-1)*normalize(tVec);\n";
			//tJS += "\tif(thisProperty.name == \"Starting Point\") {\n";
			if(argStartOrFinish == 1) {
				tJS += "\t\ttMid + tDist*tPerpUnit + tLength*tParllUnit;\n";
				//tJS += "\t} else {\n";
			} else {
				tJS += "\t\ttMid + tDist*tPerpUnit - tLength*tParllUnit;\n";
				//tJS += "\t}\n";
			}
			tJS += "} else {\n";
			tJS += "\t[-1000,-1000];\n";
			tJS += "}\n\n";
			
			tJS += "//____________________________________FUNCTIONS____________________________________\n\n";
			
			tJS += H3DreturnFunctionVectorPointToLine2D();
			
			return(tJS);
			
		}
	
	
	
		function H3DreturnBeamMainStartingEndingJS(argStartOrFinish) {
			
			var debugging_version = false;
			
			var tJS = "";
			
			tJS += H3DreturnInitialTryStatement(1,1,1,1,0,1,1);
			
			tJS += "HPlP = [effect(\"H3D: Ground Coords XY\")(\"Point\")[0],effect(\"H3D: Ground Coords XY\")(\"Point\")[1],effect(\"H3D: Ground Coords Z\")(\"Slider\")]; //ground position\n";
			tJS += "HPlV = [0,1,0]; //ground normal\n\n";
			
			tJS += "worldLine = planeIntersectPlaneUniversal(CPlV, HPlV, CPlP, HPlP);\n";
			tJS += "//world line is a point and a vector, expressing the intersection in worldspace.\n\n";
			
			tJS += "//planeLine is worldLine expressed in the layer space of the distant camera plane\n";
			tJS += "//because the plane is hypothetical, it needs to use a customised fromWorld function\n\n";
			
			tJS += "planeLine0 = fromWorldUniversal(CPlV, CPlP, CPlX, worldLine[0]); //point\n";
			tJS += "planeLine1 = fromWorldUniversal(CPlV, CPlP, CPlX, worldLine[0] + 100*worldLine[1]) - planeLine0; //vector\n";
			tJS += "planeLine = [planeLine0, planeLine1]; //expresses worldLine in the 'layer space' of the plane 1000000 away from the camera (only [0,0] is in the middle not at the top left)\n\n";

			tJS += "//screenPlaneLine is planeLine projected back to the screen plane, using the ratio of the two plane's sizes\n";
			tJS += "//hence it gives worldLine in comp space coords. the vector needn't be scaled. It doesn't change anything\n";
			tJS += "//[compWidth/2, compHeight/2] is added to convert to comp space, since the hypothetical plane's [0,0] is directly in front of the camera.\n\n";

			tJS += "tRatio = length(ScrPlP, CPos) / length(CPlP,CPos); //the ratio of the two plane's distances from camera.\n";
			tJS += "screenPlaneLine0 = [thisComp.width/2, thisComp.height/2] + [tRatio*planeLine0[0], tRatio*planeLine0[1]]; //this is now the point element of the horizon line in screen coordinates (I hope)\n";
			tJS += "screenPlaneLine1 = planeLine1;\n";
			tJS += "screenPlaneLine = [screenPlaneLine0, screenPlaneLine1];\n\n";
			
			tJS += "//find where (if not parallel) it crosses screen right and screen left\n";
			tJS += "if(planeLine1[0] != 0) {\n";
			tJS += "\txL = (0-screenPlaneLine[0][0]) / screenPlaneLine[1][0]; //xL is the scalar amount to travel from the point along the vector to reach the left edge or x = 0\n";
			tJS += "\txR = (thisComp.width-screenPlaneLine[0][0]) / screenPlaneLine[1][0]; //xR is the scalar amount to travel from the point along the vector to reach the right edge or x = thisComp.width\n\n";
	
			tJS += "\txYL = screenPlaneLine[0][1] + xL*screenPlaneLine[1][1] ;//the Y value where it crosses Left\n";
			tJS += "\txYR = screenPlaneLine[0][1] + xR*screenPlaneLine[1][1];//the Y value where it crosses Right\n\n";
			
			tJS += "\txYL = (xYL>=0 && xYL <= thisComp.height) ? [0,xYL] : -1;\n";
			tJS += "\txYR = (xYR>=0 && xYR <= thisComp.height) ? [thisComp.width,xYR] : -1;\n";
			tJS += "} else {\n";
			tJS += "\t//the line is vertical and doesn't cross\n";
			tJS += "\txYL = -1;\n";
			tJS += "\txYR = -1;\n";
			tJS += "}\n\n";
			
			tJS += "//find where (if not parallel) it crosses screen top and bottom\n";
			tJS += "if(planeLine1[1] != 0) {\n";
			tJS += "\txT = (0-screenPlaneLine0[1]) / planeLine1[1];\n";
			tJS += "\txB = (thisComp.height - screenPlaneLine0[1]) / planeLine1[1];\n";
			tJS += "\txXT = screenPlaneLine0[0] + xT*planeLine1[0]; //the X value where it crosses Top\n";
			tJS += "\txXB = screenPlaneLine0[0] + xB*planeLine1[0]; //the X value where it crosses Bottom\n\n";

			tJS += "\txXT = (xXT >= 0 && xXT <= thisComp.width) ? [xXT,0] : -1;\n";
			tJS += "\txXB = (xXB >= 0 && xXB <= thisComp.width) ? [xXB,thisComp.height] : -1;\n";
			tJS += "} else {\n";
			tJS += "\txXT = -1;\n";
			tJS += "\txXB = -1;\n";
			tJS += "}\n\n";
			
			tJS += "tStart = " + ((argStartOrFinish == 1) ? "true;\n" : "false;\n"); //thisProperty.name == \"Starting Point\";\n";
			
			//the following are new lines to get round the x-90 bug
			tJS += "try {aMult = (C.toCompVec(C.fromWorldVec([0,1,0]))[0] < 0) && (planeLine1[0] ==0)}catch(e){aMult = 0}\n";
			tJS += "if(aMult) tStart = !tStart;\n";
			//to here
			
			tJS += "tCount = 0;\n";
			tJS += "tValidPointList = [];\n\n";
			
			tJS += "for (var i = 0; i < 4; i++) {\n";
			tJS += "\tvar xList = [xYL, xYR, xXT, xXB];\n";
			tJS += "\tif(xList[i] != -1) {\n";
			tJS += "\t\ttValidPointList.push(xList[i]);\n";
			tJS += "\t}\n";
			tJS += "}\n\n";
			
			tJS += "tMinToCountAsEqual = 0.0001;\n\n";
			
			tJS += "if(tValidPointList.length>1) {\n";
			tJS += "\tif(tStart) {\n";
			tJS += "\t\t//find lowest x and put it in Starting Point\n";
			tJS += "\t\t//if x is too close, then put lowest y in Starting Point\n";
			tJS += "\t\tif(Math.abs(tValidPointList[0][0] - tValidPointList[1][0]) < tMinToCountAsEqual) {\n";
			tJS += "\t\t\tif(tValidPointList[0][1] < tValidPointList[1][1]) {\n";
			tJS += "\t\t\t\ttValidPointList[1];\n";
			tJS += "\t\t\t} else {\n";
			tJS += "\t\t\t\ttValidPointList[0];\n";
			tJS += "\t\t\t}\n";
			tJS += "\t\t} else if (tValidPointList[0][0] < tValidPointList[1][0]) {\n";
			tJS += "\t\t\ttValidPointList[0];\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\ttValidPointList[1];\n";
			tJS += "\t\t}\n";
			tJS += "\t} else {\n";
			tJS += "\t\tif(Math.abs(tValidPointList[0][0] - tValidPointList[1][0]) < tMinToCountAsEqual) {\n";
			tJS += "\t\t\tif(tValidPointList[0][1] > tValidPointList[1][1]) {\n";
			tJS += "\t\t\t\ttValidPointList[1];\n";
			tJS += "\t\t\t} else {\n";
			tJS += "\t\t\t\ttValidPointList[0];\n";
			tJS += "\t\t\t}\n";
			tJS += "\t\t} else if (tValidPointList[0][0] > tValidPointList[1][0]) {\n";
			tJS += "\t\t\ttValidPointList[0];\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\ttValidPointList[1];\n";
			tJS += "\t\t}\n";
			tJS += "\t}\n";
			tJS += "} else {\n";
			tJS += "\t[-1000,-1000];\n";
			tJS += "}\n\n";
			
			if(debugging_version) {
				//the following lines are for debugging.
				tJS += "if(thisLayer.name == \"debug\") {\n";
				tJS += "\troundToDecimalPlaces(worldLine[0],2);\n";
				tJS += "\tCPlP;\n";
				tJS += "\tScrPlP;\n";
				tJS += "\tworldLine[0];\n";
				tJS += "\ttValidPointList.length;\n";
				tJS += "\ttStr = \"\";\n";
				tJS += "\tif(xYL != -1) {\n";
				tJS += "\t\ttStr += \"xYL: [ \" + Math.round(parseFloat(xYL[0])*10)/10 + \", \" + Math.round(parseFloat(xYL[1])*10)/10 +  \"]\\r\";\n";
				tJS += "\t} else {\n";
				tJS += "\t\ttStr += \"xYL: \" + xYL + \"\r\";\n";
				tJS += "\t}\n";
				tJS += "\tif(xYR != -1) {\n";
				tJS += "\t\ttStr += \"xYR: [ \" + Math.round(parseFloat(xYR[0])*10)/10 + \", \" + Math.round(parseFloat(xYR[1])*10)/10 +  \"]\\r\";\n";
				tJS += "\t} else {\n";
				tJS += "\t\ttStr += \"xYR: \" + xYR + \"\\r\";\n";
				tJS += "\t}\n";
				tJS += "\tif(xXT != -1) {\n";
				tJS += "\t\ttStr += \"xXT: [ \" + Math.round(parseFloat(xXT[0])*10)/10 + \", \" + Math.round(parseFloat(xXT[1])*10)/10 +  \"]\\r\";\n";
				tJS += "\t} else {\n";
				tJS += "\t\ttStr += \"xXT: \" + xXT + \"\\r\";\n";
				tJS += "\t}\n";
				tJS += "\tif(xXB != -1) {\n";
				tJS += "\t\ttStr += \"xXB: [ \" + Math.round(parseFloat(xXB[0])*10)/10 + \", \" + Math.round(parseFloat(xXB[1])*10)/10 +  \"]\\r\";\n";
				tJS += "\t} else {\n";
				tJS += "\t\ttStr += \"xXB: \" + xXB + \"\\r\";\n";
				tJS += "\t}\n";
				tJS += "}\n\n";
				
			}//if(debugging_version)
	
			tJS += "//____________________________________FUNCTIONS____________________________________\n\n";
			
			tJS += H3DreturnFunctionPlaneIntersectPlaneUniversal();

			tJS += H3DreturnFunctionFromWorlUniversal();

			tJS += H3DreturnFunctionVectorIntersectPlane();

			if(debugging_version) {
				//if creating a debugging version
				tJS += H3DreturnFunctionRoundToDecimalPlaces();
			}
			
			//___________________________
			
			return(tJS);
			
			//___________________________

		}
	
		function H3DreturnBeamFloorStartingEndingJS(argStartFinish) { //1 for start 2 for finish
				
			var tJS = "";
			
			tJS += H3DreturnInitialTryStatement(1,1,1,0,1,0,0) 
			
			tJS += "HPlP = [effect(\"H3D: Ground Coords XY\")(\"Point\")[0],effect(\"H3D: Ground Coords XY\")(\"Point\")[1],effect(\"H3D: Ground Coords Z\")(\"Slider\")]; //ground position\n";
			tJS += "HPlV = [0,1,0]; //ground normal\n\n";

			tJS += "upsideDown = dot(CPlY, HPlV) < 0;\n";
			tJS += "tAboveFloor = dot((HPlP - CPos), HPlV) > 0;\n";
			tJS += "if(!tAboveFloor) upsideDown = !upsideDown;\n";
			tJS += "if(effect(\"H3D: Triangle point up\")(\"Checkbox\")<0.5) upsideDown = !upsideDown;\n\n";

			tJS += "tStart = effect(\"H3D: Beam (main)\")(\"Starting Point\");\n";
			tJS += "tEnd = effect(\"H3D: Beam (main)\")(\"Ending Point\");\n";
			tJS += "tVec  = tEnd - tStart;\n";
			tJS += "compMid = [thisComp.width/2, thisComp.height/2];\n";
			tJS += "tMid = compMid + vectorPointToLine2D(tStart, tVec, compMid);\n\n";

			tJS += "tDist = -thisProperty.propertyGroup(1)(\"Starting Thickness\")/2;\n";
			tJS += "tLength = length(tVec) + thisProperty.propertyGroup(1)(\"Starting Thickness\");\n\n";

			tJS += "if(length(tVec) > 0) {\n";
			tJS += "\ttPerpUnit = (upsideDown*2-1)*normalize([-tVec[1], tVec[0]]);\n";
			tJS += "\ttParllUnit = (upsideDown*2-1)*normalize(tVec);\n";
			//tJS += "\tif(thisProperty.name == \"Starting Point\") {\n";
			if(argStartFinish == 1) {
				tJS += "\t\ttMid + tDist*tPerpUnit + tLength*tParllUnit;\n";
				//tJS += "\t} else {\n";
			} else {
				tJS += "\t\ttMid + tDist*tPerpUnit - tLength*tParllUnit;\n";
				//tJS += "\t}\n";
			}
			tJS += "} else {\n";
			tJS += "\tif(!isFacingNormals(CPos, CPlV, HPlP, HPlV, false)) {\n";
			//tJS += "\t\tif(thisProperty.name == \"Starting Point\") {\n";
			if(argStartFinish == 1) {
				tJS += "\t\t\t[-thisComp.width/2, thisComp.height/2];\n";
			} else {//tJS += "\t\t} else {\n";
				tJS += "\t\t\t[thisComp.width*1.5, thisComp.height/2];\n";
			//tJS += "\t\t}\n";
			}
			tJS += "\t} else {\n";
			tJS += "\t\t[-thisProperty.propertyGroup(1)(\"Starting Thickness\"),-thisProperty.propertyGroup(1)(\"Starting Thickness\")];\n";
			tJS += "\t}\n";
			tJS += "}\n\n";
			tJS += "//____________________________________FUNCTIONS____________________________________\n\n";
			
			tJS += H3DreturnFunctionVectorPointToLine();

			tJS += H3DreturnFunctionIsFacingNormals();

			return(tJS);			
			
		}
	
		function H3DmainFunction() {
			//MAIN FUNCTION
			
			app.beginUndoGroup(undoStr);
			
			activeItem = proj.activeItem;
			if (!activeItem || ! activeItem instanceof CompItem){
				alert(H3D.noActiveItem);
			} else {
				
				//create a 2D layer and name it
				H3D.layer = activeItem.layers.addSolid([0,0,0], H3D.scriptName, activeItem.width, activeItem.height, activeItem.pixelAspect, activeItem.duration);
				H3D.layer.name = H3D.scriptName;
				
				//add effects.
				
				tCount = 0;
				
				FX = H3D.layer("Effects");
				
				var lineThick = FX.addProperty("ADBE Point Control");
				lineThick.name = "H3D: Line thickness 1/2";
				lineThick(1).setValue([4,2]);
				tCount++;
				
				var Clr1 = FX.addProperty("ADBE Color Control");
					Clr1.name = "H3D: Color 1";
					Clr1(1).setValue([1,1,0]);
					tCount++;
				
				if(H3D.useTriangle || H3D.useBaseline) {
					var Clr2 = FX.addProperty("ADBE Color Control");
					Clr2.name = "H3D: Color 2";
					Clr2(1).setValue([1,1,0]);
					tCount++;
				}
			
				if(H3D.useGroundfill) {			
					var Clr3 = FX.addProperty("ADBE Color Control");
					Clr3.name = "H3D: Color 3";
					Clr3(1).setValue([0.5,1,0.5]);
					tCount++;
				}
				
				if(H3D.useTriangle) {
					var triangleHeight = FX.addProperty("ADBE Point Control");
					triangleHeight.name = "H3D: Triangle height / width";
					triangleHeight(1).setValue([10,20]);
					tCount++;
				}
			
				if(H3D.useTriangle || H3D.useBaseline || H3D.useGroundfill) {
				
					var triangleUp = FX.addProperty("ADBE Checkbox Control");
					triangleUp.name = "H3D: Triangle point up";
					triangleUp(1).setValue(1);
					tCount++;
				}
			
				if(H3D.useBaseline) {
				
					var baseLineDist = FX.addProperty("ADBE Point Control");
					baseLineDist.name = "H3D: Base line distance / width";
					baseLineDist(1).setValue([-20,250]);
					tCount++;
					
				}
				
				var groundCoordsXY = FX.addProperty("ADBE Point Control");
				groundCoordsXY.name = "H3D: Ground Coords XY";
				groundCoordsXY(1).setValue([activeItem.width/2,H3D.placement]);
				tCount++;
				
				var groundCoordsZ = FX.addProperty("ADBE Slider Control");
				groundCoordsZ.name = "H3D: Ground Coords Z";
				groundCoordsZ(1).setValue(0);
				tCount++;
				
				var setChannels = FX.addProperty("ADBE Set Channels");
				setChannels.name = "H3D: Set Channels";
				setChannels(8).setValue(10);
				tCount++;
				
				//MAIN HORIZON BEAM. - ultimately must be moved to the end
				var mainBeam = FX.addProperty("ADBE Laser");
				mainBeam.name = "H3D: Beam (main)";
				mainBeam(1).expression = H3DreturnBeamMainStartingEndingJS(1);
				mainBeam(2).expression = H3DreturnBeamMainStartingEndingJS(2);
				mainBeam(3).setValue(1);
				mainBeam(4).setValue(0.5);
				mainBeam(5).expression = "effect(\"H3D: Line thickness 1/2\")(\"Point\")[0];";
				mainBeam(6).expression = "thisProperty.propertyGroup(1)(5);";
				mainBeam(7).setValue(0);
				mainBeam(8).expression = "effect(\"H3D: Color 1\")(\"Color\")";
				mainBeam(9).expression = "thisProperty.propertyGroup(1)(8);";
				mainBeam(10).setValue(0);
				mainBeam(11).setValue(1);
				tCount++;
				
				if(H3D.useGroundfill) {
					
					//FLOOR BEAM
					var floorBeam = FX.addProperty("ADBE Laser");
					floorBeam.name = "H3D: Beam (floor)";
					floorBeam(1).expression = H3DreturnBeamFloorStartingEndingJS(1);
					floorBeam(2).expression = H3DreturnBeamFloorStartingEndingJS(2);
					floorBeam(3).setValue(1);
					floorBeam(4).setValue(0.5);
					floorBeam(5).expression = "Math.sqrt(Math.pow(thisComp.width,2) + Math.pow(thisComp.height,2));";
					floorBeam(6).expression = "thisProperty.propertyGroup(1)(5);";
					floorBeam(7).setValue(0);
					floorBeam(8).expression = "effect(\"H3D: Color 3\")(\"Color\");";
					floorBeam(9).expression = "thisProperty.propertyGroup(1)(8);";
					floorBeam(10).setValue(0);
					floorBeam(11).setValue(1);
					tCount++;
					
					var blend = FX.addProperty("ADBE Blend");
					blend.name = "H3D: Blend";
					blend(3).setValue(0.2);
					tCount++;
				
				}
			
				if(H3D.useTriangle)  {
					//TRIANGLE BEAM 1
					var triangle1Beam = FX.addProperty("ADBE Laser");
					triangle1Beam.name = "H3D: Beam (triangle 1)";
					triangle1Beam(1).expression = H3DreturnBeamTriangle1JS(1,1);
					triangle1Beam(2).expression = H3DreturnBeamTriangle1JS(1,2);
					triangle1Beam(3).setValue(1);
					triangle1Beam(4).setValue(0.5);
					triangle1Beam(5).expression = "effect(\"H3D: Line thickness 1/2\")(\"Point\")[1];";
					triangle1Beam(6).expression = "thisProperty.propertyGroup(1)(5);";
					triangle1Beam(7).setValue(0);
					triangle1Beam(8).expression = "effect(\"H3D: Color 2\")(\"Color\");";
					triangle1Beam(9).expression = "thisProperty.propertyGroup(1)(8);";
					triangle1Beam(10).setValue(0);
					triangle1Beam(11).setValue(1);
					tCount++;
					
					//TRIANGLE BEAM 2
					var triangle2Beam = FX.addProperty("ADBE Laser");
					triangle2Beam.name = "H3D: Beam (triangle 2)";
					triangle2Beam(1).expression = H3DreturnBeamTriangle1JS(2,1);
					triangle2Beam(2).expression = H3DreturnBeamTriangle1JS(2,2);
					triangle2Beam(3).setValue(1);
					triangle2Beam(4).setValue(0.5);
					triangle2Beam(5).expression = "effect(\"H3D: Line thickness 1/2\")(\"Point\")[1];";
					triangle2Beam(6).expression = "thisProperty.propertyGroup(1)(5);";
					triangle2Beam(7).setValue(0);
					triangle2Beam(8).expression = "effect(\"H3D: Color 2\")(\"Color\");";
					triangle2Beam(9).expression = "thisProperty.propertyGroup(1)(8);";
					triangle2Beam(10).setValue(0);
					triangle2Beam(11).setValue(1);
					tCount++;
				}
			
				if(H3D.useBaseline) {
					//BASE LINE BEAM
					var triangle1Beam = FX.addProperty("ADBE Laser");
					triangle1Beam.name = "H3D: Beam (base line)";
					triangle1Beam(1).expression = H3DreturnBeamBaseLine(1);
					triangle1Beam(2).expression = H3DreturnBeamBaseLine(2);
					triangle1Beam(3).setValue(1);
					triangle1Beam(4).setValue(0.5);
					triangle1Beam(5).expression = "effect(\"H3D: Line thickness 1/2\")(\"Point\")[1];";
					triangle1Beam(6).expression = "thisProperty.propertyGroup(1)(5);";
					triangle1Beam(7).setValue(0);
					triangle1Beam(8).expression = "effect(\"H3D: Color 2\")(\"Color\");";
					triangle1Beam(9).expression = "thisProperty.propertyGroup(1)(8);";
					triangle1Beam(10).setValue(0);
					triangle1Beam(11).setValue(1);
					tCount++;
				}
			
				H3D.layer.property("Effects").property("H3D: Beam (main)").moveTo(tCount);
							
				H3D.layer.guideLayer = true;
				H3D.layer.locked = true;
				
				app.endUndoGroup();
				
			}
			
		} //function mainFunction()
	
	}//function DoHorizon
	
	
	//Widget 3D V1.02 (build 1) © Ben Rollason. May 2010
	
	function doWidget3D() {
		
	
		var proj = app.project;
		var undoStr = "Widget 3D";
		var activeItem = proj.activeItem;
		
		var W3D = null;
		var W3D = new Object();
		
		//basics
		W3D.scriptName = "Widget 3D";
		W3D.version = "1.0";
		W3D.scriptTitle = W3D.scriptName + " V" + W3D.version;
		
		//UI data
		W3D.scrollSize = "[130,20]";
		(parseFloat(app.version) >= 9.0) ? W3D.eTextSize = "[30,-1]" : W3D.eTextSize = "[30,15]";
		(parseFloat(app.version) >= 9.0) ? W3D.eTextSize2 = "[60,-1]" : W3D.eTextSize2 = "[60,15]";
		W3D.panelSize = "[210,-1]";
		
		//key data
		W3D.placement = 0;
		W3D.posIndex = 0; //can be 0,1 or 2.... corresponding to bottom of comp, compheight.2 below cam, origin TIP0
		W3D.usePitch = 1; //TIP1
		W3D.useHeading = 1; //TIP2
		W3D.useHeadingMarkers = 1; //TIP2a
		W3D.useHorizon = 1; //TIP3
		W3D.useInvertAlert = 1; //TIP4
		W3D.useBelowAlert = 1; //TIP5
		W3D.useAEAxes = 0; //TIP6
		W3D.rememberHM = W3D.useHeadingMarkers;
		
		//buttons
		W3D.strHelp = "?";
		W3D.strButton = "Create";
		W3D.strPlacementButton = "XYZ";
		W3D.benVFX = "vfx.benrollason.com\n\n";
		
		//help and alerts
		W3D.help = "";
		W3D.help += "© Ben Rollason 2010.\nvfx.benrollason.com\n\nRun the script to create a layer with a 3D widget on.\n\n";
		W3D.help += "Use display options to decide which features the widget should show you.";
		
		W3D.tip0 = W3D.benVFX + "The altitude (position on Y-axis) of the ground plane.\n\nSince the ground plane extends along the X and Z axes to an infinite distance, only the Y-axis (i.e. the altitude of the ground plane) is important to the Widget.";
		W3D.tip0 += "\n\nThe default is a Y value of composition height, since unlike 3D programs a floor at Y: 0 would place it above After Effects' default camera position (and having your camera underground is a bad start to any camera person's day!)";
		W3D.tip0 += "\n\nLThis setting can still be altered once the Widget has been created.";
		
		W3D.tip1 = W3D.benVFX + "Check this to display the camera's pitch (also known as elevation). Pitch describes to what extent the camera is pointing up at the sky or down at the ground.\n\nPilots like to use pitch to work out whether they're about to stall the plane.";
		W3D.tip2 = W3D.benVFX + "Check this to display the camera's heading (also known as yaw, bearing, azimuth). Heading describes in which direction the camera is facing with respect to the ground.\n\nPilots like to use heading to know where on earth they're flying to.";
		W3D.tip2a = W3D.benVFX + "Check this to put two dots on the heading display to indicate at which heading the camera is facing directly along the X and Z axes.\n\nThe Heading Markers setting is linked to Heading. It will be automatically turned off when Heading is turned off and will reset to its previous state when Heading is turned back on.";
		W3D.tip3 = W3D.benVFX + "Check this to display the horizon, which shows the camera's roll (also know as bank) and also provides an indication of whether the camera is above or below the ground plane.";
		W3D.tip4 = W3D.benVFX + "Check this to make a little alert light come on when the camera is upside down.\n\nOK, so it's pretty obvious if the ground is above you and your coffee falls upwards - but sometimes you don't have a coffee and you can't see the ground.";
		W3D.tip5 = W3D.benVFX + "Unlike a real camera, the After Effects camera can operate just as effectively underground. If the ground is above you, then you're either upside down or underground.\n\nCheck this to make a little alert light come on when the camera is below the ground plane.";
		W3D.tip6 = W3D.benVFX + "By default, Widget 3D displays the axes as most 3D programs show them: the Y-axis points upwards and the Z-axis points towards you.\n\n";
		W3D.tip6 += "However, After Effects is curious in that it measures Y from the top of the screen, increasing as you move downwards. Z depth increases as you move into the screen.\n\nClick this checkbox to show the true confusion of After Effects axes instead of the more intuitive default setting. (You can also change this from inside the AE interface later.)";
				
		W3D.notEnglish = "As for most scripts, After Effects needs to be running in English for " + W3D.scriptName + " to work.";
		W3D.versionTooOld = "You need to be using After Effects CS3 or above for " + W3D.scriptName + " to work.";
		W3D.noActiveItem = "You must have a composition selected to run " + W3D.scriptName + ".";
		
		if(W3Dpreflight()) {	
				
			if(activeItem && activeItem != null && activeItem instanceof CompItem) {
				W3D.placement = activeItem.height;
			} else {
				W3D.placement = 0;
			}
			
			W3D.toolsPanel = W3DcreateUI(this);
			W3D.toolsPanel.show();
			
			//testCheckBoxCombos();//for testing purposes
			
		}
	
		function W3DtestCheckBoxCombos() {
			//for testing purposes
			for(j = 126; j< 128; j++) { //max 128
				tS = "";
				for(k = 0; k<  7-dec2bin(j).length; k++) {
					tS += "0";
				}
				tS = tS + dec2bin(j);
				
				tList = [];
				for(k=0; k<7; k++) {
					tList.push(parseInt(tS.charAt(k)));
				}
				alert(tList);
				
				W3D.usePitch = tList[0];
				W3D.useHeading = tList[1];
				W3D.useHeadingMarkers = tList[2];
				W3D.useHorizon = tList[3]; 
				W3D.useInvertAlert = tList[4];
				W3D.useBelowAlert = tList[5]; 
				W3D.useAEAxes = tList[6];
				
				mainFunction();
			}
		
		}
	
		function W3Ddec2bin(x) {
			
			if ((/[^0-9]/g.test(x)) || x == "") {
				//alert ("You must enter an integer decimal number!");
				return false;
			}
			x = parseInt(x);
			var bin = x.toString(2);
			var hex = x.toString(16).toUpperCase();
			var octal = x.toString(8);

			return(bin)

		}


		function W3Dplacement(aIndex) {
			
			//redundant method - maybe useful for future though, so I'll leave it in!
			
			var tRet;
			
			switch (aIndex) 
			
			{
			
				case 0:
					
					// original at middle bottom of default camera's view
					tRet = [activeItem.width/2, activeItem.height, 0];
					break;
					
				case 1:
				
					//origin compheight/2 below the current camera
					
					if(activeItem.activeCamera) {
						W3D.camPos = activeItem.activeCamera.transform.position.value;
						W3D.camPos = [Math.round(W3D.camPos[0]), Math.round(W3D.camPos[1]), Math.round(W3D.camPos[2])];
					} else {
						W3D.camPos = [ activeItem.width/2,  activeItem.height/2, Math.round((- activeItem.width/2) / Math.tan(degsToRads(39.6/2)))];
					}
					
					tRet = W3D.camPos + [0, activeItem.height/2, 0]; 
					break;
					
				case 2:
				
					//origin at world origin
					tRet = [0,0,0];
					break;
					
				case 3:
				
					//origin at middle bottom of current camera's view
					//this is work in progress and requires a math version of expression language's toWorld function.
					
					if(activeItem.activeCamera) {
						W3D.camPos = activeItem.activeCamera.transform.position.value;
					} else {
						W3D.camPos = [ activeItem.width/2,  activeItem.height/2, Math.round((- activeItem.width/2) / Math.tan(degsToRads(39.6/2)))];
					}
					
					tRet = [0,0,0];//tRet = ??
					break;
					
				default:
				
					tRet = [activeItem.width/2, activeItem.height, 0];
					break;
					
				
			}
		
			return(tRet);
			
			
		}
	
		function W3DdegsToRads(degs) {
			return(Math.PI*2*degs/360);
		}
	
	
		function W3Dpreflight() {
				
			var isEnglish = (app.isoLanguage == "en_US") || (app.language == Language.ENGLISH);
			var appVersionTooOld = (parseFloat(app.version) < 8.0)
	
			if(appVersionTooOld) {
				alert(W3D.versionTooOld);
				return(false);
			} else if (!isEnglish) {
				alert(W3D.notEnglish);
				return(false);
			} else {
				return(true);
			}
		
		}
		
	
		function W3DcreateUI(thisObj) {
			
			var pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", W3D.scriptName, undefined, {resizeable:true}); //replace undefined with [300,300,570,550]??
				
			if (pal != null) {
					
				var res =
					"group { \
						orientation:'column', alignment:['left','top'], \
						Panel1: Panel {\
							text: 'Ground Placement', orientation: 'row', minimumSize:" + W3D.panelSize + ", margins: 15, spacing: 5, \
							Gr1: Group {\
								alignment:['left','center'], minimumSize: [120,-1],  spacing:15,\
								placementYText: StaticText { text:'Y-axis', preferredSize:[-1,-1], alignment:['left','center'] }, \
								placementYEditText: EditText { text:'" + W3D.placement + "', characters:6, preferredSize:" + W3D.eTextSize2 + ", alignment:['left','center'], } \
							}\
							Gr2: Group {\
								alignment:['right','center'], spacing:15,\
								tip0: Button { text:'" + W3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
							}\
						}\
						Panel2: Panel { text: 'Display Options', orientation: 'column', minimumSize:" + W3D.panelSize + ", margins:15, spacing: 5, \
							Gr1: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr1a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									pitchText: StaticText { text:'Pitch:', minimumSize:[90,-1], alignment:['left','center'] }, \
									pitchCheckbox:Checkbox {text:'',alignment:['left','center'],value:" + W3D.usePitch + ", preferredSize: [25,25],},\
								}\
								Gr1b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip1: Button { text:'" + W3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
							Gr2: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr2a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									headingText: StaticText { text:'Heading:', minimumSize:[90,-1], alignment:['left','center'] }, \
									headingCheckbox:Checkbox {text:'',alignment:['left','center'],value: " + W3D.useHeading + ", preferredSize: [25,25],},\
								}\
								Gr2b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip2: Button { text:'" + W3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
							Gr2a: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr2aa: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									headingMarkersText: StaticText { text:'Heading marker:', minimumSize:[90,-1], alignment:['left','center'] }, \
									headingMarkersCheckbox:Checkbox {text:'',alignment:['left','center'],value:" + W3D.useHeadingMarkers + ", preferredSize: [25,25],},\
								}\
								Gr2ab: Group {\
									alignment: ['right','center'], spacing:5,\
									tip2a: Button { text:'" + W3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
							Gr3: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr3a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									horizonText: StaticText { text:'Horizon:', minimumSize:[90,-1], alignment:['left','center'] }, \
									horizonCheckbox:Checkbox {text:'',alignment:['left','center'],value:" + W3D.useHorizon + ", preferredSize: [25,25],},\
								}\
								Gr3b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip3: Button { text:'" + W3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
							Gr4: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr4a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									invertAlertText: StaticText { text:'Invert alert:', minimumSize:[90,-1], alignment:['left','center'] }, \
									invertAlertCheckbox:Checkbox {text:'',alignment:['left','center'],value:" + W3D.useInvertAlert + ", preferredSize: [25,25],},\
								}\
								Gr4b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip4: Button { text:'" + W3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
							Gr5: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr5a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									belowAlertText: StaticText { text:'Below alert:', minimumSize:[90,-1], alignment:['left','center'] }, \
									belowAlertCheckbox:Checkbox {text:'',alignment:['left','center'],value:" + W3D.useBelowAlert + ", preferredSize: [25,25],},\
								}\
								Gr5b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip5: Button { text:'" + W3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
							Gr6: Group {\
								alignment:['fill','center'], spacing:15,\
								Gr6a: Group {\
									alignment: ['left','center'], minimumSize: [90,-1], \
									aeAxesText: StaticText { text:'AE Axes:', minimumSize:[90,-1], alignment:['left','center'] }, \
									aeAxesCheckbox:Checkbox {text:'',alignment:['left','center'],value:" + W3D.useAEAxes + ", preferredSize: [25,25],},\
								}\
								Gr6b: Group {\
									alignment: ['right','center'], spacing:5,\
									tip6: Button { text:'" + W3D.strHelp + "', preferredSize:[30,20], alignment:['right','center'] }, \
								}\
							}\
						}\
						footer: Group { \
							alignment:['right','top'], \
							help: Button { text:'" + W3D.strHelp + "', preferredSize:[30,20], alignment:['left','center'] }, \
							mainButton: Button { text:'" + W3D.strButton +"', preferredSize:[60,20], alignment:['right','center'] }, \
						}, \
					}";
					
					
				pal.grp = pal.add(res);
				
				var darkBrush = pal.graphics.newPen(pal.graphics.BrushType.SOLID_COLOR, [0,0,0], 1);
				pal.grp.Panel1.Gr1.placementYEditText.graphics.foregroundColor  = darkBrush;
				
				pal.layout.layout(true);
				pal.grp.minimumSize = pal.grp.size;
				pal.layout.resize();
				pal.onResizing = pal.onResize = function () {this.layout.resize();}
				//pal.onFocus = alert("focus");
				
				pal.grp.Panel1.Gr1.placementYEditText.onChange = function() 
				{
					if (isNaN(this.text)) this.text = W3D.placement;
					W3D.placement = parseFloat(this.text);
				}
				
				pal.grp.Panel1.Gr2.tip0.onClick = function () {alert(W3D.scriptTitle + " - Ground Placement\n" + W3D.tip0, W3D.scriptName);}
				pal.grp.Panel2.Gr1.Gr1b.tip1.onClick = function () {alert(W3D.scriptTitle + " - Pitch\n" + W3D.tip1, W3D.scriptName);}
				pal.grp.Panel2.Gr2.Gr2b.tip2.onClick = function () {alert(W3D.scriptTitle + " - Heading\n" + W3D.tip2, W3D.scriptName);}
				pal.grp.Panel2.Gr2a.Gr2ab.tip2a.onClick = function () {alert(W3D.scriptTitle + " - Heading Markers\n" + W3D.tip2a, W3D.scriptName);}
				pal.grp.Panel2.Gr3.Gr3b.tip3.onClick = function () {alert(W3D.scriptTitle + " - Horizon\n" + W3D.tip3, W3D.scriptName);}
				pal.grp.Panel2.Gr4.Gr4b.tip4.onClick = function () {alert(W3D.scriptTitle + " - Invert Alert\n" + W3D.tip4, W3D.scriptName);}
				pal.grp.Panel2.Gr5.Gr5b.tip5.onClick = function () {alert(W3D.scriptTitle + " - Below Alert\n" + W3D.tip5, W3D.scriptName);}
				pal.grp.Panel2.Gr6.Gr6b.tip6.onClick = function () {alert(W3D.scriptTitle + " - AE Axes\n" + W3D.tip6, W3D.scriptName);}
				
				pal.grp.Panel2.Gr1.Gr1a.pitchCheckbox.onClick = function () {W3D.usePitch = pal.grp.Panel2.Gr1.Gr1a.pitchCheckbox.value}
				pal.grp.Panel2.Gr2.Gr2a.headingCheckbox.onClick = function () 
				{
					W3D.useHeading = pal.grp.Panel2.Gr2.Gr2a.headingCheckbox.value;
					if(!W3D.useHeading) {
						W3D.rememberHM = W3D.useHeadingMarkers;
						W3D.useHeadingMarkers = 0;
						pal.grp.Panel2.Gr2a.Gr2aa.headingMarkersCheckbox.value = W3D.useHeadingMarkers;
					} else {
						W3D.useHeadingMarkers = W3D.rememberHM;
						pal.grp.Panel2.Gr2a.Gr2aa.headingMarkersCheckbox.value = W3D.useHeadingMarkers;
					}					
				}
				pal.grp.Panel2.Gr2a.Gr2aa.headingMarkersCheckbox.onClick = function () 
				{
					if(W3D.useHeading == 0) {
						pal.grp.Panel2.Gr2a.Gr2aa.headingMarkersCheckbox.value = 0;
					} else {
						W3D.useHeadingMarkers = pal.grp.Panel2.Gr2a.Gr2aa.headingMarkersCheckbox.value;
						W3D.rememberHM = W3D.useHeadingMarkers;
					}
				}
				pal.grp.Panel2.Gr3.Gr3a.horizonCheckbox.onClick = function () {W3D.useHorizon = pal.grp.Panel2.Gr3.Gr3a.horizonCheckbox.value}
				pal.grp.Panel2.Gr4.Gr4a.invertAlertCheckbox.onClick = function () {W3D.useInvertAlert = pal.grp.Panel2.Gr4.Gr4a.invertAlertCheckbox.value}
				pal.grp.Panel2.Gr5.Gr5a.belowAlertCheckbox.onClick = function () {W3D.useBelowAlert = pal.grp.Panel2.Gr5.Gr5a.belowAlertCheckbox.value}
				pal.grp.Panel2.Gr6.Gr6a.aeAxesCheckbox.onClick = function () {W3D.useAEAxes = pal.grp.Panel2.Gr6.Gr6a.aeAxesCheckbox.value}

				pal.grp.footer.help.onClick = function () {alert(W3D.scriptTitle + "\n" + W3D.help, W3D.scriptName);}
				pal.grp.footer.mainButton.onClick = W3DmainFunction;
				
				
				
			
				
			} //if (pal != null)
		
			return(pal);
			
		} // function createUI
		

		function W3Dtrace(s) {
			$.writeln(s); // writes to the ExtendScript interface
			//writeLn("3DR: " + s); // writes in the AE info window
		}
	
		function W3DreturnFunctionMainBeamColor() {
			
			var tJS = "";
			
			tJS += "myNum = 3;\n";
			tJS += "AEAxes = effect(\"3DW XX: AE Axes\")(\"Checkbox\") > 0.5;\n\n";

			tJS += "if(thisProperty.propertyGroup(1).name.indexOf(\"Beam 1\") != -1) {\n";
			tJS += "\tmyNum = 0;\n";
			tJS += "} else if(thisProperty.propertyGroup(1).name.indexOf(\"Beam 2\") != -1) {\n";
			tJS += "\tmyNum = 1;\n";
			tJS += "} else if(thisProperty.propertyGroup(1).name.indexOf(\"Beam 3\") != -1) {\n";
			tJS += "\tmyNum = 2;\n";
			tJS += "}\n\n";

			tJS += "tSize = effect(\"3DW XX: Size (diameter)\")(\"Slider\");\n\n";

			tJS += "colX = effect(\"3DW X: Color X-Axis\")(\"Color\");\n";
			tJS += "colY = effect(\"3DW X: Color Y-Axis\")(\"Color\");\n";
			tJS += "colZ = effect(\"3DW X: Color Z-Axis\")(\"Color\");\n";
			tJS += "colHub = effect(\"3DW X: Color Hub\")(\"Color\");\n\n";

			tJS += "try {\n";
			tJS += "\tC = thisComp.activeCamera;\n";
			tJS += "\tCPos = C.toWorld([0,0,0]);\n";
			tJS += "\tCN = C.toWorldVec([0,0,1]);\n\n";
			
			tJS += "\ttCols = [colX, colY, colZ, colHub];\n\n";
			
			tJS += "\tL = [[1,0,0],[0,-1,0],[0,0,-1]];\n";
			tJS += "\tif(AEAxes) L = [[1,0,0],[0,1,0],[0,0,1]];\n\n";
			
			tJS += "\tP1 = C.toWorld([0,0,0]) + C.toWorldVec([0,0,1])*C.cameraOption(\"Zoom\");\n\n";
			
			tJS += "\tP2X = P1 + 0.44*tSize*L[0];\n";
			tJS += "\tP2Y = P1 + 0.44*tSize*L[1];\n";
			tJS += "\tP2Z = P1 + 0.44*tSize*L[2];\n";
			tJS += "\tP2HUB = P1;\n\n";
			
			tJS += "\t//order the list of points\n";
			tJS += "\tdistList = [P2X];\n";
			tJS += "\tcolList = [colX];\n\n";
			
			tJS += "\ttoInsertList = [P2Y, P2Z, P2HUB];\n";
			tJS += "\ttoInsertList2 = [colY, colZ, colHub];\n\n";
			
			tJS += "\tfor (var j in toInsertList) {\n";
			tJS += "\t\ttSet = false;\n";
			tJS += "\t\tfor (var i in distList) {\n";
			tJS += "\t\t\tif (Math.abs(dot(CPos-toInsertList[j], CN)) > Math.abs(dot(CPos-distList[i], CN)) ) {\n";
			tJS += "\t\t\t\tcontinue;\n";
			tJS += "\t\t\t} else {\n";
			tJS += "\t\t\t\tdistList.splice(i,0,toInsertList[j]);\n";
			tJS += "\t\t\t\tcolList.splice(i, 0, toInsertList2[j]);\n";
			tJS += "\t\t\t\ttSet = true;\n";
			tJS += "\t\t\t\tbreak;\n";
			tJS += "\t\t\t}\n";
			tJS += "\t\t}\n";
			tJS += "\t\tif(!tSet) {\n";
			tJS += "\t\t\tdistList.push(toInsertList[j]);\n";
			tJS += "\t\t\tcolList.push(toInsertList2[j]);\n";
			tJS += "\t\t}\n";
			tJS += "\t}\n\n";

			tJS += "\t//distList.reverse(); //biggest to smallest distance\n";
			tJS += "\tcolList.reverse();\n\n";
			
			tJS += "\t//P2 = distList[myNum];\n";
			tJS += "\tcol = colList[myNum];\n\n";
			
			tJS += "} catch (e) {\n\n";
			
			tJS += "\ttCols = [colX, colY, colHub, colZ];\n";
			tJS += "\tif(AEAxes) tCols = [colX, colY, colZ, colHub];\n";
			tJS += "\ttCols[myNum];\n";
			tJS += "}\n";
			
			return(tJS);
		}

	
		function W3DreturnFunctionMainBeamThickness() {
	
			var tJS = ""
			
			tJS += "myNum = 3;\n";
			tJS += "AEAxes = effect(\"3DW XX: AE Axes\")(\"Checkbox\") > 0.5;\n\n";

			tJS += "if(thisProperty.propertyGroup(1).name.indexOf(\"Beam 1\") != -1) {\n";
			tJS += "\tmyNum = 0;\n";
			tJS += "} else if(thisProperty.propertyGroup(1).name.indexOf(\"Beam 2\") != -1) {\n";
			tJS += "\tmyNum = 1;\n";
			tJS += "} else if(thisProperty.propertyGroup(1).name.indexOf(\"Beam 3\") != -1) {\n";
			tJS += "\tmyNum = 2;\n";
			tJS += "}\n\n";

			tJS += "tSize = effect(\"3DW XX: Size (diameter)\")(\"Slider\");\n";
			tJS += "tHubSize = effect(\"3DW XX: Hub Size\")(\"Slider\")/100;\n\n";

			tJS += "try {\n";
			tJS += "\tC = thisComp.activeCamera;\n";
			tJS += "\tCPos = C.toWorld([0,0,0]);\n";
			tJS += "\tCN = C.toWorldVec([0,0,1]);\n\n";
			
			tJS += "\tthickList = [1, 1, 1, tHubSize];\n\n";
			
			tJS += "\tL = [[1,0,0],[0,-1,0],[0,0,-1]];\n";
			tJS += "\tif (AEAxes) L = L = [[1,0,0],[0,1,0],[0,0,1]];\n";
			tJS += "\tP1 = C.toWorld([0,0,0]) + C.toWorldVec([0,0,1])*C.cameraOption(\"Zoom\");\n\n";
			
			tJS += "\tP2X = P1 + 0.44*tSize*L[0];\n";
			tJS += "\tP2Y = P1 + 0.44*tSize*L[1];\n";
			tJS += "\tP2Z = P1 + 0.44*tSize*L[2];\n";
			tJS += "\tP2HUB = P1;\n\n";
			
			tJS += "\t//order the list of points\n";
			tJS += "\tdistList = [P2X];\n";
			tJS += "\tthickList = [1];\n\n";
			
			tJS += "\ttoInsertList = [P2Y, P2Z, P2HUB];\n";
			tJS += "\ttoInsertList2 = [1, 1, tHubSize];\n\n";
			
			tJS += "\tfor (var j in toInsertList) {\n";
			tJS += "\t\ttSet = false;\n";
			tJS += "\t\tfor (var i in distList) {\n";
			tJS += "\t\t\tif (Math.abs(dot(CPos-toInsertList[j], CN)) > Math.abs(dot(CPos-distList[i], CN)) ) {\n";
			tJS += "\t\t\t\tcontinue;\n";
			tJS += "\t\t\t} else {\n";
			tJS += "\t\t\t\tdistList.splice(i,0,toInsertList[j]);\n";
			tJS += "\t\t\t\tthickList.splice(i, 0, toInsertList2[j]);\n";
			tJS += "\t\t\t\ttSet = true;\n";
			tJS += "\t\t\t\tbreak;\n";
			tJS += "\t\t\t}\n";
			tJS += "\t\t}\n";
			tJS += "\t\tif(!tSet) {\n";
			tJS += "\t\t\tdistList.push(toInsertList[j]);\n";
			tJS += "\t\t\tthickList.push(toInsertList2[j]);\n";
			tJS += "\t\t}\n";
			tJS += "\t}\n\n";

			tJS += "\t//distList.reverse(); //biggest to smallest distance\n";
			tJS += "\tthickList.reverse();\n\n";

			tJS += "\t//P2 = distList[myNum];\n";
			tJS += "\tthick = 0.033*effect(\"3DW XX: Size (diameter)\")(\"Slider\")*thickList[myNum];\n\n";
			
			tJS += "} catch (e) {\n\n";
			
			tJS += "\ttThick = [1, 1, tHubSize, 1];\n";
			tJS += "\tif(AEAxes) tThick = [1,1,1,tHubSize];\n";
			tJS += "\t0.033*effect(\"3DW XX: Size (diameter)\")(\"Slider\")*tThick[myNum];\n";
			tJS += "}";
			
			return(tJS);
		}

	
	
		function W3DreturnFunctionMainBeams(argStartEnd) {
		
			var tJS = "";
			
			tJS += "tHubSize = effect(\"3DW XX: Hub Size\")(\"Slider\")/100;\n"
			tJS += "AEAxes = effect(\"3DW XX: AE Axes\")(\"Checkbox\") > 0.5;\n";
			tJS += "myNum = 3;\n\n";

			tJS += "if(thisProperty.propertyGroup(1).name.indexOf(\"Beam 1\") != -1) {\n";
			tJS += "\t\tmyNum = 0;\n";
			tJS += "} else if(thisProperty.propertyGroup(1).name.indexOf(\"Beam 2\") != -1) {\n";
			tJS += "\tmyNum = 1;\n";
			tJS += "} else if(thisProperty.propertyGroup(1).name.indexOf(\"Beam 3\") != -1) {\n";
			tJS += "\tmyNum = 2;\n";
			tJS += "}\n\n";
			
			tJS += "tSize = effect(\"3DW XX: Size (diameter)\")(\"Slider\");\n";

			tJS += "try {\n";
			tJS += "\tC = thisComp.activeCamera;\n";
			tJS += "\tCPos = C.toWorld([0,0,0]);\n";
			tJS += "\tCN = C.toWorldVec([0,0,1]);\n\n";
			
			tJS += "\tL = [[1,0,0],[0,-1,0],[0,0,-1]];\n";
			tJS += "\tif(AEAxes) L = [[1,0,0], [0,1,0], [0,0,1]];\n\n";
			
			tJS += "\tP1 = C.toWorld([0,0,0]) + C.toWorldVec([0,0,1])*C.cameraOption(\"Zoom\");\n\n";
			
			tJS += "\tP2X = P1 + 0.44*tSize*L[0];\n";
			tJS += "\tP2Y = P1 + 0.44*tSize*L[1];\n";
			tJS += "\tP2Z = P1 + 0.44*tSize*L[2];\n";
			tJS += "\tP2HUB = P1;\n\n";
			
			tJS += "\t//order the list of points\n";
			tJS += "\tdistList = [P2X];\n";
			tJS += "\ttoInsertList = [P2Y, P2Z, P2HUB];\n\n";
			
			tJS += "\tfor (var j in toInsertList) {\n";
			tJS += "\t\ttSet = false;\n";
			tJS += "\t\tfor (var i in distList) {\n";
			tJS += "\t\t\tif (Math.abs(dot(CPos-toInsertList[j], CN)) > Math.abs(dot(CPos-distList[i], CN)) ) {\n";
			tJS += "\t\t\t\tcontinue;\n";
			tJS += "\t\t\t} else {\n";
			tJS += "\t\t\t\tdistList.splice(i,0,toInsertList[j]);\n";
			tJS += "\t\t\t\ttSet = true;\n";
			tJS += "\t\t\t\tbreak;\n";
			tJS += "\t\t\t}\n";
			tJS += "\t\t}\n";
			tJS += "\t\tif(!tSet) distList.push(toInsertList[j]);\n";
			tJS += "\t}\n\n";

			tJS += "\tdistList.reverse(); //biggest to smallest distance\n";
			tJS += "\tP2 = distList[myNum];\n\n";
			
			if(argStartEnd == 1) {
				tJS += "\tP1a = P1 + tHubSize*tSize/7500*(P2-P1)\n";
				tJS += "\tSCR1 = C.toComp(C.fromWorld(P1a));\n";
			} else {
				tJS += "\t\tSCR2 = C.toComp(C.fromWorld(P2));\n";
			}	
			
			tJS += "} catch (e) {\n\n";
			
			tJS += "\tSCR1 = [thisComp.width/2, thisComp.height/2];\n";
			tJS += "\tL = [[1,0,0],[0,-1,0],[0,0,0],[0,0,-1]];\n";
			tJS += "\tif(AEAxes) L = [[1,0,0],[0,1,0],[0,0,1],[0,0,0]];\n";
			tJS += "\tSCR2 = SCR1 + 0.44*tSize*L[myNum];\n";
			tJS += "\tV = tHubSize*tSize/7500*(SCR2-SCR1);\n\n";

			if(argStartEnd == 1) {
				
				tJS += "\tSCR1 + V;\n\n";
				
			} else {
	
				tJS += "\tSCR2;\n";
				
			}
		
			tJS += "}\n";
			
			return(tJS);
		}

	
		function W3DreturnInitialTryStatement(aC, aCPos, aCPlV, aCPlX, aCPlY, aCPlP, aScrPlP) {
					
			var tJS = "";
			var tJS2 = "";
			var tJS3 = "";
			
			tJS += "try {\n";
			if(aC) tJS += "\tC = thisComp.activeCamera;\n";
			if(aCPos) tJS += "\tCPos = C.toWorld([0,0,0]);\n";
			if(aCPlV) tJS += "\tCPlV = C.toWorldVec([0,0,1]);\n";
			if(aCPlX) tJS += "\tCPlX = C.toWorldVec([1,0,0]);\n";
			if(aCPlY) tJS += "\tCPlY = C.toWorldVec([0,1,0]);\n";
			if(aCPlP) tJS += "\tCPlP = CPos + CPlV*Math.pow(10,9); //the world position of the big screen (1,000,000 from the camera)\n";
			if(aScrPlP) tJS += "\tScrPlP = CPos + CPlV*C.cameraOption.zoom; //the world position of the normal screen\n";
			tJS+= "} catch(e) {\n";
			
			tJS2 += "\ttry {\n";
			if(aC) tJS2 += "\t\tC = thisComp.layer(\"default cam pos\");\n";
			if(aCPos) tJS2 += "\t\tCPos = C.toWorld([0,0,0]);\n";
			if(aCPlV) tJS2 += "\t\tCPlV = C.toWorldVec([0,1,0]);\n";
			if(aCPlX) tJS2 += "\t\tCPlX = C.toWorldVec([1,0,0]);\n";
			if(aCPlY) tJS2 += "\t\tCPlY = C.toWorldVec([0,1,0]);\n";
			if(aCPlP) tJS2 += "\t\tCPlP = CPos + CPlV*Math.pow(10,9); //the world position of the big screen (1,000,000 from the camera)\n";
			if(aScrPlP) tJS2 += "\t\tScrPlP = CPos - CPlV*C.position[2];\n";
			tJS2 += "\t} catch(e) {\n";
			if(aCPos) tJS2 += "\t\tCPos = [thisComp.width/2, thisComp.height/2, (-thisComp.width/2) / Math.tan(degreesToRadians(39.6/2))];\n";
			if(aCPlV) tJS2 +=  "\t\tCPlV = [0,0,1];\n";
			if(aCPlX) tJS2 += "\tCPlX = [1,0,0];\n";
			if(aCPlY) tJS2 += "\t\tCPlY = [0,1,0];\n";
			if(aCPlP) tJS2 += "\t\tCPlP = CPlV*Math.pow(10,9) +CPos;\n";
			if(aScrPlP) tJS2 == "\t\tScrPlP = CPos - CPlV*CPos[2];\n";
			tJS2 += "\t}\n";
			tJS2 += "}\n\n";
			
			if(aCPos) tJS3 += "\tCPos = [thisComp.width/2, thisComp.height/2, (-thisComp.width/2) / Math.tan(degreesToRadians(39.6/2))];\n";
			if(aCPlV) tJS3 +=  "\tCPlV = [0,0,1];\n";
			if(aCPlX) tJS3 += "\tCPlX = [1,0,0];\n";
			if(aCPlY) tJS3 += "\tCPlY = [0,1,0];\n";
			if(aCPlP) tJS3 += "\tCPlP = CPlV*Math.pow(10,9) +CPos;\n";
			if(aScrPlP) tJS3 += "\tScrPlP = CPos - CPlV*CPos[2];\n";
			tJS3 += "}\n\n";
			
			//return(tJS + tJS2); //long version
			return(tJS + tJS3);
		
		}
	
		function W3DreturnFunctionVectorToElevationAzimuth() {
			
			var tJS = "";
			tJS += "function vectorToElevationAzimuth(aVec, aAxis) {\n\n";

			tJS += "\tif(aAxis == null) aAxis = 1;\n";
			tJS += "\t\tif(aAxis == 0) {\n";
			tJS += "\t\t\ttElevation = radiansToDegrees(Math.asin(-aVec[0]/length(aVec)));\n";
			tJS += "\t\t\ttAzimuth = radiansToDegrees(Math.atan2(aVec[1], -aVec[2]));\n";
			tJS += "\t\t\ttAzimuth = (tAzimuth+360) % 360;\n";
			tJS += "\t\t} else if (aAxis == 2) {\n";
			tJS += "\t\t\ttElevation = radiansToDegrees(Math.asin(aVec[2]/length(aVec)));\n";
			tJS += "\t\ttAzimuth = radiansToDegrees(Math.atan2(aVec[0], aVec[1]));\n"; 
			tJS += "\t\ttAzimuth = (tAzimuth+270) % 360;\n";
			tJS += "\t} else  {  //if (aAxis == 1) or something random!\n";
			tJS += "\t\t//default\n";
			tJS += "\t\ttElevation = radiansToDegrees(Math.asin(aVec[1]/length(aVec)));\n";
			tJS += "\t\ttAzimuth = radiansToDegrees(Math.atan2(aVec[0], -aVec[2]));\n";
			tJS += "\t\ttAzimuth = (tAzimuth+270) % 360;\n";
			tJS += "\t}\n\n";
			
			tJS += "return ([tElevation, tAzimuth]);\n\n"; 
			tJS += "}";
			
			return(tJS);
		}
	
	
		function W3DreturnFunctionVectorIntersectPlane() {
			
			var tJS = "";
			
			tJS += "function vectorIntersectPlane(aVectorPoint, aVectorNormal, aPlanePoint, aPlaneNormal) {\n";
			tJS += "\tP0 = aVectorPoint;\n";
			tJS += "\tu = aVectorNormal;\n";
			tJS += "\tV0 = aPlanePoint;\n";
			tJS += "\tn = aPlaneNormal;\n";
			tJS += "\tw = P0 - V0;\n";
			tJS += "\tif(dot(n,u) != 0) {\n";
			tJS += "\t\ts = dot(-n,w) /  dot(n,u);\n";
			tJS += "\t\tr = P0 + s*u;\n";
			tJS += "\t\treturn(r);\n";
			tJS += "\t} else {\n";
			tJS += "\t\t//there is no solution vector is parallel to plane or lies on the plane\n";
			tJS += "\t\tif(dot(n, w) == 0) {\n";
			tJS += "\t\t\t//the point is on the plane\n";
			tJS += "\t\t\treturn(P0);\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\treturn(-1);\n";
			tJS += "\t\t}\n";
			tJS += "\t}\n";
			tJS += "}\n";			
			
			return(tJS);			
		}
	
		function W3DreturnFunctionFromWorlUniversal() {
			
			var tJS = "";
			
			tJS += "function fromWorldUniversal(aPlaneNormal, aPlanePoint, aPlaneXNormal, aPoint) {\n";
			tJS += "\taPlaneYNormal = normalize(cross(aPlaneNormal, aPlaneXNormal));\n";
			tJS += "\ttZ = dot(aPoint - aPlanePoint, aPlaneNormal);\n";
			tJS += "\ttY = dot(aPoint - aPlanePoint, aPlaneYNormal);\n";
			tJS += "\ttX = dot(aPoint - aPlanePoint, aPlaneXNormal);\n";
			tJS += "\treturn([tX,tY,tZ]);\n";
			tJS += "}\n\n";
			
			return(tJS);
			
		}
	
		function W3DreturnFunctionRoundToDecimalPlaces() {
			
			var tJS = "";
			
			tJS += "function roundToDecimalPlaces(aNumOrArray, aDP) {\n";
			tJS += "\ttIsArray = aNumOrArray instanceof Array;\n";
			tJS += "\ttIsNum = (typeof aNumOrArray == 'number') || (aNumOrArray instanceof Number);\n";
			tJS += "\tif(tIsArray) {\n";
			tJS += "\t\tfor (i in aNumOrArray) {\n";
			tJS += "\t\t\tif((typeof aNumOrArray[i] == 'number') || (aNumOrArray[i] instanceof Number)) {\n";
			tJS += "\t\t\t\taNumOrArray[i] = Math.round(aNumOrArray[i]*Math.pow(10, aDP))/Math.pow(10,aDP);\n";
			tJS += "\t\t\t\t//aNumOrArray[i] = aNumOrArray.toFixed(aDP);\n";
			tJS += "\t\t\t}\n";
			tJS += "\t\t}\n";
			tJS += "\t} else if (tIsNum) {\n";
			tJS += "\t\taNumOrArray = Math.round(aNumOrArray*Math.pow(10, aDP))/Math.pow(10,aDP);\n";
			tJS += "\t\t//aNumOrArray = aNumOrArray.toFixed(aDP);\n";
			tJS += "\t}\n";
			tJS += "\treturn(aNumOrArray);\n";
			tJS += "}\n\n";
				
			return(tJS);
		}
	
		
	
		function W3DreturnFunctionVectorPointToLine() {

			var tJS = "";
			
			tJS += "function vectorPointToLine2D(linePoint, lineVector, point) {\n";
			tJS += "\tv0 = linePoint - point;\n";
			tJS += "\tlinePerp = normalize([-lineVector[1], lineVector[0]]);\n";
			tJS += "\tif(length(lineVector) > 0) {\n";
			tJS += "\t\td = dot(v0, linePerp);\n";
			tJS += "\t\treturn(d*linePerp);\n";
			tJS += "\t} else {\n";
			tJS += "\t\treturn([-1000,-1000]);\n";
			tJS += "\t}\n";
			tJS += "}\n\n";

			return(tJS);
		}
	
		function W3DreturnFunctionVectorPointToLine2D() {
			
			var tJS = "";
			
			tJS += "function vectorPointToLine2D(linePoint, lineVector, point) {\n";
			tJS += "\tv0 = linePoint - point;\n";
			tJS += "\tlinePerp = normalize([-lineVector[1], lineVector[0]]);\n";
			tJS += "\tif(length(lineVector) > 0) {\n";
			tJS += "d = dot(v0, linePerp);\n";
			tJS += "\t\treturn(d*linePerp);\n";
			tJS += "\t} else {\n";
			tJS += "\t\treturn([-1000,-1000]);\n";
			tJS += "\t}\n";
			tJS += "}\n\n";
			
			return(tJS);		
			
		}
	
	
		function W3DreturnFunctionIsFacingNormals(){
		
			var tJS = "";
			
			tJS += "function isFacingNormals(Point1, Normal1, Point2, Normal2, aLookAtEachOther) {\n";
			tJS += "\tw = Point1 - Point2;\n";
			tJS += "\tif(dot(Normal2,Normal1) != 0) {\n";
			tJS += "\t\ts1 = dot(-Normal2,w) /  dot(Normal2,Normal1);\n";
			tJS += "\t} else {\n";
			tJS += "\t\t//there is no solution vector is parallel to plane or lies on the plane\n";
			tJS += "\t\t//so it doesn't really matter what value we give s\n";
			tJS += "\t\ts1 = 0;\n";
			tJS += "\t}\n";
			tJS += "\tif(aLookAtEachOther) {\n";
			tJS += "\t\t//now switch it round\n";
			tJS += "\t\tw = Point2 - Point1;\n";
			tJS += "\t\tif(dot(Normal1,Normal2) != 0) {\n";
			tJS += "\t\t\ts2 = dot(-Normal1,w) /  dot(Normal1,Normal2);\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\t//there is no solution vector is parallel to plane or lies on the plane\n";
			tJS += "\t\t\t//so it doesn't really matter what value we give s\n";
			tJS += "\t\t\ts2 = 0;\n";
			tJS += "\t\t}\n";
			tJS += "\t\tif (s1 ==0 || s2 == 0) {\n";
			tJS += "\t\t\treturn(-1);\n";
			tJS += "\t\t} else {\n";
			tJS += "\t\t\treturn(s2 < 0 && s1 <0);\n";
			tJS += "\t\t}\n";
			tJS += "\t} else {\n";
			tJS += "\t\treturn(s1 < 0);\n";
			tJS += "\t}\n";
			tJS += "}\n\n";
			
			return(tJS);
		
		}
	
		function W3DreturnFunctionPlaneIntersectPlaneUniversal() {
		
			var tJS = "";
			
			tJS +="function planeIntersectPlaneUniversal(n1, n2, P1, P2) {\n";
			tJS += "\tif ((n1 == n2) || (n1 == -n2)) {\n";
			tJS += "\t\t//planes are parallel\n";
			tJS += "\t\treturn(-1);\n";
			tJS += "\t} else {\n";
			tJS += "\t\tV = cross(n1,n2);\n";
			tJS += "\t\t//get point\n";
			tJS += "\t\t//to find any specific point on the line, take an arbitrary vector on the first plane\n";
			tJS += "\t\t//and use code from vectorIntersectPlane to find where it meets the second plane.\n";
			tJS += "\t\t//this is of course, also on the line.\n";
			tJS += "\t\tx1 = cross(n1, n1+[20,0,0]); //get x normal (arbitrary perpendicular to n1)\n";
			tJS += "\t\ty1 = cross(n1, x1);// and y normal - perpendicular to both\n";
			tJS += "\t\tP1a = P1 + 1000*normalize(x1) + 1000*normalize(y1); //an arbitrary point on Plane 1's surface\n";
			tJS += "\t\tu = P1a-P1; //an arbitrary vector on it's surface\n";
			tJS += "\t\tP = vectorIntersectPlane(P1, u, P2, n2);\n";
			tJS += "\t\tif(P == -1) {\n";
			tJS += "\t\t\t//we have been unlucky with our arbitrarily chosen vector. It is parallel to the plane.\n";
			tJS += "\t\t\t//Since we know the planes are not parallel, we try again with another slightly different vector.\n";
			tJS += "\t\t\t//It isn't possible that the second one doesn't meet it.\n";
			tJS += "\t\t\tP1a = P1 + 1000*normalize(x1) + 900*normalize(y1); //an arbitrary point on Plane 1's surface\n";
			tJS += "\t\t\tu = P1a-P1; //an arbitrary vector on it's surface\n";
			tJS += "\t\t\tP = vectorIntersectPlane(P1, u, P2, n2);\n";
			tJS += "\t\t}\n";
			tJS += "\t\treturn([P,V]); // point and vector that describe the line of intersection\n";
			tJS += "\t}\n";				   
			tJS += "}\n\n";
			
			return(tJS);			
			
		}
	
		
	
		
		function W3DreturnBeamHorizonJS(argStartEnd) {

				var tJS = "";
				tJS += W3DreturnInitialTryStatement(1,1,1,1,1,1,1);
				tJS += "groundPlane = effect(\"3DW XX: Ground Plane Y\")(\"Slider\");\n";
				tJS += "HPlP = [thisComp.width/2, groundPlane, 0]; //ground position\n";
				tJS += "HPlV = [0,1,0]; //ground normal\n\n";

				tJS += "tAboveFloor = dot((HPlP - CPos), HPlV) > 0;\n";
				tJS += "tFlipFloor = (effect(\"3DW XX: Flip Below Floor\")(\"Checkbox\") > 0.5);\n";
				tJS += "if(!tFlipFloor) {tAboveFloor = 1};\n\n";

				tJS += "worldLine = planeIntersectPlaneUniversal(CPlV, HPlV, CPlP, HPlP);\n\n";

				tJS += "planeLine0 = fromWorldUniversal(CPlV, CPlP, CPlX, worldLine[0]); //point\n";
				tJS += "planeLine1 = fromWorldUniversal(CPlV, CPlP, CPlX, worldLine[0] + 100*worldLine[1]) - planeLine0; //vector\n\n";

				tJS += "tSize = 1.1*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2;\n\n";

				tJS += "if(planeLine1[0] != 0) {\n";
				tJS += "\ttStart = [thisComp.width/2, thisComp.height/2] + tSize*normalize(planeLine1);\n";
				tJS += "\ttEnd = [thisComp.width/2, thisComp.height/2] - tSize*normalize(planeLine1);\n\n";
				tJS += "} else {\n";
				tJS += "\t//vertical\n";
				tJS += "\ttry {\n";
				tJS += "\t\taMult = C.toCompVec(C.fromWorldVec([0,1,0]))[0] > 0;\n";
				tJS += "\t\tbMult = !aMult;\n";
				tJS += "\t\taMult = aMult*2-1;\n";
				tJS += "\t\tbMult = bMult*2-1;\n";
				tJS += "\t} catch (e) {\n";
				tJS += "\t\taMult = 1;\n";
				tJS += "\t\tbMult = -1;\n";
				tJS += "\t}\n\n";
					
				tJS += "\ttStart = [thisComp.width/2, thisComp.height/2] + aMult*[0,tSize];\n";
				tJS += "\ttEnd = [thisComp.width/2, thisComp.height/2] + bMult*[0,tSize];\n";
				tJS += "}\n\n";

				tJS += "tVec  = tEnd - tStart;\n";
				tJS += "upsideDown = dot(CPlY, HPlV) < 0;\n";
				tJS += "compMid = [thisComp.width/2, thisComp.height/2];\n";
				tJS += "tMid = compMid;\n";

				tJS += "tDist = -thisProperty.propertyGroup(1)(\"Starting Thickness\")/2;\n";
				tJS += "tLength = length(tVec) + thisProperty.propertyGroup(1)(\"Starting Thickness\");\n\n";


				tJS += "if(length(tVec) > 0) {\n";
				tJS += "\ttPerpUnit = (!tAboveFloor*2-1)*normalize([-tVec[1], tVec[0]]);\n";
				tJS += "\t//tPerpUnit = -normalize([-tVec[1], tVec[0]]);\n";
				tJS += "\ttParllUnit = (upsideDown*2-1)*normalize(tVec);\n";
				if(argStartEnd == 1) {
					//tJS += "\tif(thisProperty.name == \"Starting Point\") {\n";
					tJS += "\ttMid + tDist*tPerpUnit + tLength/2*tParllUnit;\n";
				} else {
					//tJS += "\t} else {\n";
					tJS += "\ttMid + tDist*tPerpUnit - tLength/2*tParllUnit;\n";
				}
				//tJS += "\t}\n";
				
				tJS += "} else {\n";
				if(argStartEnd == 1) {
					//tJS += "\tif(thisProperty.name == \"Starting Point\") {\n";
					tJS += "\t[-thisComp.width/2, thisComp.height/2];\n";
				} else {
					//tJS += "\t} else {\n";
					tJS += "\t[thisComp.width*1.5, thisComp.height/2];\n";
				}
				//tJS += "\t}\n";
				
				tJS += "}\n\n";

				tJS +="//____________________________FUNCTIONS___________________________________\n\n";
				
				tJS += W3DreturnFunctionPlaneIntersectPlaneUniversal();
				
				tJS += W3DreturnFunctionVectorIntersectPlane();
				
				tJS += W3DreturnFunctionFromWorlUniversal();

				tJS += W3DreturnFunctionVectorPointToLine2D();

				tJS += W3DreturnFunctionIsFacingNormals();
				
				return(tJS);
			
			
		}
	
		function W3DreturnBeamPitchStartJS() {
			
			var tJS = "";

			tJS += W3DreturnInitialTryStatement(1, 0, 1, 0, 0, 0, 0);

			tJS += "groundPlane = effect(\"3DW XX: Ground Plane Y\")(\"Slider\");\n";
			tJS += "HPlP = [thisComp.width/2, groundPlane, 0]; //ground position\n";
			tJS += "HPlV = [0,1,0]; //ground normal\n\n";

			tJS += "pitch = -vectorToElevationAzimuth(CPlV)[0];\n";
			tJS += "tSize = effect(\"3DW XX: Size (diameter)\")(\"Slider\");\n";
			tJS += "tInverter = (thisProperty.propertyGroup(1).name.indexOf(\"L)\") == -1)*2-1;\n";
			tJS += "y =thisComp.height/2 - Math.sin(degreesToRadians(pitch))*tSize*1.15/2;\n";
			tJS += "x =  thisComp.width/2  + tInverter*( Math.cos(degreesToRadians(pitch))*tSize*1.15/2 + tSize/5);\n";
			tJS += "[x,y];\n\n";

			tJS += "//__________________________________FUNCTIONS_____________________________________\n\n";

			tJS += W3DreturnFunctionVectorToElevationAzimuth();
			
			return(tJS);
		}
	
		function W3DreturnBeamPitchEndJS() {
			
			var tJS = "";
			
			tJS += "tStart = thisProperty.propertyGroup(1)(\"Starting Point\");\n";
			tJS += "tSize = effect(\"3DW XX: Size (diameter)\")(\"Slider\");\n";
			tJS += "tMaxOffset = Math.sin(degreesToRadians(90))*tSize*1.15/2;\n";
			tJS += "tOffsetRatio = 2*(Math.abs(tStart[1] - thisComp.height/2)/tMaxOffset);\n";
			tJS += "tMultiplier = Math.pow(tOffsetRatio,3);\n";
			tJS += "tExtra = 0.06*tMultiplier*tSize;\n";
			tJS += "tExtra = (tExtra < 0.25*tSize) ? 0.25*tSize : tExtra;\n";
			tJS += "tLeft = (thisProperty.propertyGroup(1).name.indexOf(\"L)\") != -1)*2-1;\n";
			tJS += "tStart +  [tLeft*tExtra,0];";

			return(tJS);
		}
	
		function W3DreturnBeamHeadingJS(argStartEnd) {
		
			var tJS = "";
			
			tJS += W3DreturnInitialTryStatement(1, 1, 1, 1, 1, 1, 1);
			
			tJS += "groundPlane = effect(\"3DW XX: Ground Plane Y\")(\"Slider\");\n";
			tJS += "HPlP = [thisComp.width/2, groundPlane, 0]; //ground position\n";
			tJS += "HPlV = [0,1,0]; //ground normal\n\n";

			tJS += "heading = vectorToElevationAzimuth(CPlV)[1]+90;\n\n";

			tJS += "opp = Math.sin(degreesToRadians(heading));\n";
			tJS += "adj = Math.cos(degreesToRadians(heading));\n";
			tJS += (argStartEnd == 1) ? "tMult = 1.3;\n" : "tMult = 1.4;\n";
			tJS += "tSize = tMult*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2;\n\n";

			tJS += "[thisComp.width/2, thisComp.height/2] + tSize*[opp, adj];\n\n";

			tJS += "//__________________________________FUNCTIONS_____________________________________\n\n";

			tJS += W3DreturnFunctionVectorToElevationAzimuth();

			return(tJS);
		}


	


	
	
	
		function W3DmainFunction() {
			
			//MAIN FUNCTION
			
			proj = app.project;
			activeItem = proj.activeItem;
		
			if (!activeItem || ! activeItem instanceof CompItem){
				alert(W3D.noActiveItem);
			} else {
				
				app.beginUndoGroup(undoStr);
			
				//create a 2D layer and name it
				W3D.layer = activeItem.layers.addSolid([0,0,0], W3D.scriptName, activeItem.width, activeItem.height, activeItem.pixelAspect, activeItem.duration);
				W3D.layer.name = W3D.scriptName;
				
				//add effects.
				
				tCount = 0;
				
				FX = W3D.layer("Effects");
				
				var mainSize = FX.addProperty("ADBE Slider Control");
				mainSize.name = "3DW XX: Size (diameter)";
				mainSize(1).setValue(activeItem.width/12);
				
				var mainPos = FX.addProperty("ADBE Point Control");
				mainPos.name = "3DW XX: Position";
				mainPos(1).setValue([activeItem.width/12, activeItem.width/12]);
				
				var groundPlaneY = FX.addProperty("ADBE Slider Control");
				groundPlaneY.name = "3DW XX: Ground Plane Y";
				groundPlaneY(1).setValue(W3D.placement);
				
				var aeAxes = FX.addProperty("ADBE Checkbox Control");
				aeAxes.name = "3DW XX: AE Axes";
				aeAxes(1).setValue(W3D.useAEAxes);
				
				var hubSize = FX.addProperty("ADBE Slider Control");
				hubSize.name = "3DW XX: Hub Size";
				hubSize(1).setValue(200);
				
				var flip = FX.addProperty("ADBE Checkbox Control");
				flip.name = "3DW XX: Flip Below Floor";
				flip(1).setValue(1);
				
				var colorX = FX.addProperty("ADBE Color Control");
				colorX.name = "3DW X: Color X-Axis";
				colorX(1).setValue([1,0,0]);
				
				var colorY = FX.addProperty("ADBE Color Control");
				colorY.name = "3DW X: Color Y-Axis";
				colorY(1).setValue([0,1,0]);
				
				var colorZ = FX.addProperty("ADBE Color Control");
				colorZ.name = "3DW X: Color Z-Axis";
				colorZ(1).setValue([0.25,0.25,1]);
				
				var colorHub = FX.addProperty("ADBE Color Control");
				colorHub.name = "3DW X: Color Hub";
				colorHub(1).setValue([1,1,1]);
				
				var colorBkgnd = FX.addProperty("ADBE Color Control");
				colorBkgnd.name = "3DW X: Color Background";
				colorBkgnd(1).setValue([0,0,0]);
			
				if(W3D.usePitch) {
					var colorPitch = FX.addProperty("ADBE Color Control");
					colorPitch.name = "3DW X: Color Pitch";
					colorPitch(1).setValue([1,1,1]);
				}
			
				if(W3D.useHeading) {
					var colorHeading = FX.addProperty("ADBE Color Control");
					colorHeading.name = "3DW X: Color Heading";
					colorHeading(1).setValue([1,1,1]);
				}
			
				if(W3D.useHorizon) {
					var colorHorizon = FX.addProperty("ADBE Color Control");
					colorHorizon.name = "3DW X: Color Horizon";
					colorHorizon(1).setValue([1,1,1]);
				}
			
				if(W3D.useInvertAlert) {
					var colorInvertAlert = FX.addProperty("ADBE Color Control");
					colorInvertAlert.name = "3DW X: Color Invert Alert";
					colorInvertAlert(1).setValue([1,0,0]);
				}
			
				if(W3D.useBelowAlert) {
					var colorBelowAlert = FX.addProperty("ADBE Color Control");
					colorBelowAlert.name = "3DW X: Color Below Alert";
					colorBelowAlert(1).setValue([1,0,1]);
				}
			
				if(W3D.useHorizon) {
					var opHorizon = FX.addProperty("ADBE Slider Control");
					opHorizon.name = "3DW X: Opacity Horizon";
					opHorizon(1).setValue(15);
				}
			
				var opBkgnd = FX.addProperty("ADBE Slider Control");
				opBkgnd.name = "3DW X: Opacity Background";
				opBkgnd(1).setValue(40);
				
				if(W3D.useInvertAlert) {
					var invAlL = FX.addProperty("ADBE Checkbox Control");
					invAlL.name = "3DW X: Invert Alert Left";
					invAlL(1).setValue(0);
				}
			
				if(W3D.useBelowAlert) {
					var belAlL = FX.addProperty("ADBE Checkbox Control");
					belAlL.name = "3DW X: Below Alert Left";
					belAlL(1).setValue(0);
				}
			
				var blend = FX.addProperty("ADBE Blend");
				blend.name = "3DW: Blend";
				blend(3).setValue(0);
			
				if(W3D.useHorizon) {
					var beamHorizon = FX.addProperty("ADBE Laser");
					beamHorizon.name = "3DW: Beam (horizon)";
					beamHorizon(1).expression = W3DreturnBeamHorizonJS(1);
					beamHorizon(2).expression = W3DreturnBeamHorizonJS(2);
					beamHorizon(3).setValue(1);
					beamHorizon(4).setValue(0.5);
					beamHorizon(5).expression = "effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2;";
					beamHorizon(6).expression = "thisProperty.propertyGroup(1)(5);";
					beamHorizon(7).setValue(0);
					beamHorizon(8).expression = "effect(\"3DW X: Color Horizon\")(\"Color\");";
					beamHorizon(9).expression = "thisProperty.propertyGroup(1)(8);";
					beamHorizon(10).setValue(0);
					beamHorizon(11).setValue(1);
		
					var blend2 = FX.addProperty("ADBE Blend");
					blend2.name = "3DW: Blend (horizon)";
					blend2(3).expression = "effect(\"3DW X: Opacity Horizon\")(\"Slider\");";

					var circleMatte1 = FX.addProperty("ADBE Circle");
					circleMatte1.name = "3DW: Circle Matte (horizon)";
					circleMatte1(2).expression = "effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2;";
					circleMatte1(10).setValue([0,0,0]);
					circleMatte1(12).setValue(3);
				}
				
				var ring = FX.addProperty("ADBE Circle");
				ring.name = "3DW: Ring";
				ring(2).expression = "1.2*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2;";
				ring(3).setValue(3);
				ring(4).expression = "0.2*effect(\"3DW: Ring\")(\"Radius\");";
				ring(10).setValue([1,1,1]);
				ring(11).setValue(33);
				ring(12).setValue(2);
				
				if(W3D.usePitch) {
					var beamPitchL = FX.addProperty("ADBE Laser");
					beamPitchL.name = "3DW: Beam (pitch L)";
					beamPitchL(1).expression = W3DreturnBeamPitchStartJS();
					beamPitchL(2).expression = W3DreturnBeamPitchEndJS();
					beamPitchL(3).setValue(1);
					beamPitchL(4).setValue(0.5);
					beamPitchL(5).expression = "0.033*effect(\"3DW XX: Size (diameter)\")(\"Slider\");";
					beamPitchL(6).expression = "thisProperty.propertyGroup(1)(5);";
					beamPitchL(7).setValue(0);
					beamPitchL(8).expression = "effect(\"3DW X: Color Pitch\")(\"Color\");";
					beamPitchL(9).expression = "thisProperty.propertyGroup(1)(8);";
					beamPitchL(10).setValue(0);
					beamPitchL(11).setValue(1);
					
					var beamPitchR = FX.addProperty("ADBE Laser");
					beamPitchR.name = "3DW: Beam (pitch R)";
					beamPitchR(1).expression = W3DreturnBeamPitchStartJS();
					beamPitchR(2).expression = W3DreturnBeamPitchEndJS();
					beamPitchR(3).setValue(1);
					beamPitchR(4).setValue(0.5);
					beamPitchR(5).expression = "0.033*effect(\"3DW XX: Size (diameter)\")(\"Slider\");";
					beamPitchR(6).expression = "thisProperty.propertyGroup(1)(5);";
					beamPitchR(7).setValue(0);
					beamPitchR(8).expression = "effect(\"3DW X: Color Pitch\")(\"Color\");";
					beamPitchR(9).expression = "thisProperty.propertyGroup(1)(8);";
					beamPitchR(10).setValue(0);
					beamPitchR(11).setValue(1);
				}
			
				var stencil1 = FX.addProperty("ADBE Circle");
				stencil1.name = "3DW: Stencil Ring";
				stencil1(2).expression = "1.1*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2;";
				stencil1(3).setValue(2);
				stencil1(4).expression = "1.02*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2";
				stencil1(9).setValue(1);
				stencil1(10).setValue([1,1,1]);
				stencil1(11).setValue(100);
				stencil1(12).setValue(3);
				
				var stencil2 = FX.addProperty("ADBE Circle");
				stencil2.name = "3DW: Stencil Ring 2";
				stencil2(2).expression = "3*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2;";
				stencil2(3).setValue(2);
				stencil2(4).expression = "1.22*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2";
				stencil2(9).setValue(1);
				stencil2(10).setValue([1,1,1]);
				stencil2(11).setValue(100);
				stencil2(12).setValue(3);
				
				var solidComp = FX.addProperty("ADBE Solid Composite");
				solidComp.name = "3DW: Solid Comp (bkgnd)";
				solidComp(2).expression = "effect(\"3DW X: Color Background\")(\"Color\");";
				solidComp(3).expression = "effect(\"3DW X: Opacity Background\")(\"Slider\");";
				
				var circleMatte2 = FX.addProperty("ADBE Circle");
				circleMatte2.name = "3DW: Circle Matte (bkgnd)";
				circleMatte2(2).expression = "1.63*(effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2);";
				circleMatte2(10).setValue([0,0,0]);
				circleMatte2(11).setValue(100);
				circleMatte2(12).setValue(3);
				
				if(W3D.useHeading) {
					
					if(W3D.useHeadingMarkers) {
						var beamHMX = FX.addProperty("ADBE Laser");
						beamHMX.name = "3DW: Beam (heading marker X)";
						beamHMX(1).expression = "tSize = 1.4*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2;\n[thisComp.width/2, thisComp.height/2] + tSize*[1, 0];";
						beamHMX(2).expression = "thisProperty.propertyGroup(1)(1);";
						beamHMX(3).setValue(1);
						beamHMX(4).setValue(0.5);
						beamHMX(5).expression = "1.5*0.033*effect(\"3DW XX: Size (diameter)\")(\"Slider\");";
						beamHMX(6).expression = "thisProperty.propertyGroup(1)(5);";
						beamHMX(7).setValue(0);
						beamHMX(8).expression = "effect(\"3DW X: Color X-Axis\"            )(\"Color\");";
						beamHMX(9).expression = "thisProperty.propertyGroup(1)(8);";
						beamHMX(10).setValue(0);
						beamHMX(11).setValue(1);
						
						var beamHMZ = FX.addProperty("ADBE Laser");
						beamHMZ.name = "3DW: Beam (heading marker Z)";
						beamHMZ(1).expression = "tSize = 1.4*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2;\n[thisComp.width/2, thisComp.height/2] + tSize*[0, -1];";
						beamHMZ(2).expression = "thisProperty.propertyGroup(1)(1);";
						beamHMZ(3).setValue(1);
						beamHMZ(4).setValue(0.5);
						beamHMZ(5).expression = "1.5*0.033*effect(\"3DW XX: Size (diameter)\")(\"Slider\");";
						beamHMZ(6).expression = "thisProperty.propertyGroup(1)(5);";
						beamHMZ(7).setValue(0);
						beamHMZ(8).expression = "effect(\"3DW X: Color Z-Axis\")(\"Color\");";
						beamHMZ(9).expression = "thisProperty.propertyGroup(1)(8);";
						beamHMZ(10).setValue(0);
						beamHMZ(11).setValue(1);
					}
					
					var beamHeading = FX.addProperty("ADBE Laser");
					beamHeading.name = "3DW: Beam (heading marker Z)";
					beamHeading(1).expression = W3DreturnBeamHeadingJS(1);
					beamHeading(2).expression = W3DreturnBeamHeadingJS(2) ;
					beamHeading(3).setValue(1);
					beamHeading(4).setValue(0.5);
					beamHeading(5).expression = "0.033*effect(\"3DW XX: Size (diameter)\")(\"Slider\");";
					beamHeading(6).expression = "thisProperty.propertyGroup(1)(5);";
					beamHeading(7).setValue(0);
					beamHeading(8).expression = "effect(\"3DW X: Color Heading\")(\"Color\");";
					beamHeading(9).expression = "thisProperty.propertyGroup(1)(8);";
					beamHeading(10).setValue(0);
					beamHeading(11).setValue(1);
					
				}
					
				if(W3D.useInvertAlert) {
					var invertAlerter = FX.addProperty("ADBE Circle");
					invertAlerter.name = "3DW: Circle (invert alert)";
					invertAlerter(1).expression = "pitchRight = effect(\"3DW X: Invert Alert Left\")(\"Checkbox\") > 0.5;\n[thisComp.width/2, thisComp.height/2] + [(!pitchRight*2-1)*1*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2, 1*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2];";
					invertAlerter(2).expression = "effect(\"3DW XX: Size (diameter)\")(\"Slider\")/15;";
					invertAlerter(3).setValue(2);
					invertAlerter(4).expression = "thisProperty.propertyGroup(1)(2)/2;";
					invertAlerter(10).expression = "effect(\"3DW X: Color Invert Alert\")(\"Color\");";
					invertAlerter(11).expression = "try {\n\tC = thisComp.activeCamera;\n\tCPlY = C.toWorldVec([0,1,0]);\n} catch(e) {\n\tCPlY = [0,1,0];\n}\n\nHPlV = [0,1,0]; //ground normal\nupsideDown = dot(CPlY, HPlV) < 0;\nupsideDown*value;\n";
					invertAlerter(12).setValue(2);
				}
				
				if(W3D.useBelowAlert) {
					var belowAlerter = FX.addProperty("ADBE Circle");
					belowAlerter.name = "3DW: Circle (below alert)";
					belowAlerter(1).expression = "pitchRight = effect(\"3DW X: Below Alert Left\")(\"Checkbox\") > 0.5;\n[thisComp.width/2, thisComp.height/2] + [(!pitchRight*2-1)*1*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2, -1*effect(\"3DW XX: Size (diameter)\")(\"Slider\")/2];";
					belowAlerter(2).expression = "effect(\"3DW XX: Size (diameter)\")(\"Slider\")/15;";
					belowAlerter(3).setValue(2);
					belowAlerter(4).expression = "thisProperty.propertyGroup(1)(2)/2;";
					belowAlerter(10).expression = "effect(\"3DW X: Color Below Alert\")(\"Color\");";
					var ttJS = "try {\n\tC = thisComp.activeCamera;\n\tCPos = C.toWorld([0,0,0]);\n\tCPlY = C.toWorldVec([0,1,0]);\n} catch(e) {\n\tCPlY = [0,1,0];\n";
					ttJS +="\tCPos = [thisComp.width/2, thisComp.height/2, (-thisComp.width/2) / Math.tan(degreesToRadians(39.6/2))];\n}\n\ngroundPlane = effect(\"3DW XX: Ground Plane Y\")(\"Slider\");\n";
					ttJS += "HPlP = [thisComp.width/2, groundPlane, 0]; //ground position\nHPlV = [0,1,0]; //ground normal\n\ntAboveFloor = dot((HPlP - CPos), HPlV) > 0;\n\n(!tAboveFloor)*value;";
					belowAlerter(11).expression = ttJS;
					belowAlerter(12).setValue(2);
				}
				
				var mainBeam1 = FX.addProperty("ADBE Laser");
				mainBeam1.name = "3DW: Beam 1";
				mainBeam1(1).expression = W3DreturnFunctionMainBeams(1);
				mainBeam1(2).expression = W3DreturnFunctionMainBeams(2);
				mainBeam1(3).setValue(1);
				mainBeam1(4).setValue(0.5);
				mainBeam1(5).expression = W3DreturnFunctionMainBeamThickness();
				mainBeam1(6).expression = "thisProperty.propertyGroup(1)(5);";
				mainBeam1(7).setValue(0);
				mainBeam1(8).expression = W3DreturnFunctionMainBeamColor();
				mainBeam1(9).expression = "thisProperty.propertyGroup(1)(8);";
				mainBeam1(10).setValue(0);
				mainBeam1(11).setValue(1);
				
				var mainBeam2 = FX.addProperty("ADBE Laser");
				mainBeam2.name = "3DW: Beam 2";
				mainBeam2(1).expression = W3DreturnFunctionMainBeams(1);
				mainBeam2(2).expression = W3DreturnFunctionMainBeams(2);
				mainBeam2(3).setValue(1);
				mainBeam2(4).setValue(0.5);
				mainBeam2(5).expression = W3DreturnFunctionMainBeamThickness();
				mainBeam2(6).expression = "thisProperty.propertyGroup(1)(5);";
				mainBeam2(7).setValue(0);
				mainBeam2(8).expression = W3DreturnFunctionMainBeamColor();
				mainBeam2(9).expression = "thisProperty.propertyGroup(1)(8);";
				mainBeam2(10).setValue(0);
				mainBeam2(11).setValue(1);
				
				var mainBeam3 = FX.addProperty("ADBE Laser");
				mainBeam3.name = "3DW: Beam 3";
				mainBeam3(1).expression = W3DreturnFunctionMainBeams(1);
				mainBeam3(2).expression = W3DreturnFunctionMainBeams(2);
				mainBeam3(3).setValue(1);
				mainBeam3(4).setValue(0.5);
				mainBeam3(5).expression = W3DreturnFunctionMainBeamThickness();
				mainBeam3(6).expression = "thisProperty.propertyGroup(1)(5);";
				mainBeam3(7).setValue(0);
				mainBeam3(8).expression = W3DreturnFunctionMainBeamColor();
				mainBeam3(9).expression = "thisProperty.propertyGroup(1)(8);";
				mainBeam3(10).setValue(0);
				mainBeam3(11).setValue(1);
				
				var mainBeam4 = FX.addProperty("ADBE Laser");
				mainBeam4.name = "3DW: Beam 4";
				mainBeam4(1).expression = W3DreturnFunctionMainBeams(1);
				mainBeam4(2).expression = W3DreturnFunctionMainBeams(2);
				mainBeam4(3).setValue(1);
				mainBeam4(4).setValue(0.5);
				mainBeam4(5).expression = W3DreturnFunctionMainBeamThickness();
				mainBeam4(6).expression = "thisProperty.propertyGroup(1)(5);";
				mainBeam4(7).setValue(0);
				mainBeam4(8).expression = W3DreturnFunctionMainBeamColor();
				mainBeam4(9).expression = "thisProperty.propertyGroup(1)(8);";
				mainBeam4(10).setValue(0);
				mainBeam4(11).setValue(1);
				
				var transform = FX.addProperty("ADBE Geometry2");
				transform(2).expression = "effect(\"3DW XX: Position\")(\"Point\");";
				
				W3D.layer.guideLayer = true;
				W3D.layer.locked = true;			
				
				app.endUndoGroup();
				
			} //if(activeItem....
			
		} //function mainFunction()
	
	}//function doWidget3D

}